/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Channel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    @Deprecated
    public static byte[] toByteArray(String string) throws IOException {
        return string.getBytes(UTF_8);
    }

    public static char[] toCharArray(InputStream inputStream) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, charArrayWriter, string);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static String toString(InputStream inputStream) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, stringWriter, string);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    @Deprecated
    public static String toString(byte[] byArray) throws IOException {
        return new String(byArray, UTF_8);
    }

    @Deprecated
    public static String toString(byte[] byArray, String string) throws IOException {
        if (string == null) {
            return new String(byArray, UTF_8);
        }
        return new String(byArray, string);
    }

    public static List<String> readLines(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, UTF_8);
        return IOUtils.readLines(inputStreamReader);
    }

    public static List<String> readLines(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            return IOUtils.readLines(inputStream);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        return IOUtils.readLines(inputStreamReader);
    }

    public static List<String> readLines(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        while (string != null) {
            arrayList.add(string);
            string = bufferedReader.readLine();
        }
        return arrayList;
    }

    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence.toString());
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) throws IOException {
        return IOUtils.toInputStream(charSequence.toString(), string);
    }

    public static InputStream toInputStream(String string) {
        byte[] byArray = string.getBytes(UTF_8);
        return new ByteArrayInputStream(byArray);
    }

    public static InputStream toInputStream(String string, String string2) throws IOException {
        byte[] byArray = string2 != null ? string.getBytes(string2) : string.getBytes(UTF_8);
        return new ByteArrayInputStream(byArray);
    }

    public static void write(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void write(byte[] byArray, Writer writer) throws IOException {
        if (byArray != null) {
            writer.write(new String(byArray, UTF_8));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) throws IOException {
        if (byArray != null) {
            if (string == null) {
                IOUtils.write(byArray, writer);
            } else {
                writer.write(new String(byArray, string));
            }
        }
    }

    public static void write(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    public static void write(char[] cArray, OutputStream outputStream) throws IOException {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes(UTF_8));
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) throws IOException {
        if (cArray != null) {
            if (string == null) {
                IOUtils.write(cArray, outputStream);
            } else {
                outputStream.write(new String(cArray).getBytes(string));
            }
        }
    }

    public static void write(CharSequence charSequence, Writer writer) throws IOException {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), writer);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream) throws IOException {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), outputStream);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) throws IOException {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), outputStream, string);
        }
    }

    public static void write(String string, Writer writer) throws IOException {
        if (string != null) {
            writer.write(string);
        }
    }

    public static void write(String string, OutputStream outputStream) throws IOException {
        if (string != null) {
            outputStream.write(string.getBytes(UTF_8));
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) throws IOException {
        if (string != null) {
            if (string2 == null) {
                IOUtils.write(string, outputStream);
            } else {
                outputStream.write(string.getBytes(string2));
            }
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, Writer writer) throws IOException {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream) throws IOException {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes(UTF_8));
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) throws IOException {
        if (stringBuffer != null) {
            if (string == null) {
                IOUtils.write(stringBuffer, outputStream);
            } else {
                outputStream.write(stringBuffer.toString().getBytes(string));
            }
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = IOUtils.copyLarge(inputStream, outputStream);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, UTF_8);
        IOUtils.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        if (string == null) {
            IOUtils.copy(inputStream, writer);
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            IOUtils.copy((Reader)inputStreamReader, writer);
        }
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        long l = IOUtils.copyLarge(reader, writer);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = reader.read(cArray))) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, UTF_8);
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) throws IOException {
        if (string == null) {
            IOUtils.copy(reader, outputStream);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            IOUtils.copy(reader, (Writer)outputStreamWriter);
            outputStreamWriter.flush();
        }
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream.read();
        while (-1 != n2) {
            n = inputStream2.read();
            if (n2 != n) {
                return false;
            }
            n2 = inputStream.read();
        }
        n = inputStream2.read();
        return n == -1;
    }

    public static boolean contentEquals(Reader reader, Reader reader2) throws IOException {
        int n;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        if (!(reader2 instanceof BufferedReader)) {
            reader2 = new BufferedReader(reader2);
        }
        int n2 = reader.read();
        while (-1 != n2) {
            n = reader2.read();
            if (n2 != n) {
                return false;
            }
            n2 = reader.read();
        }
        n = reader2.read();
        return n == -1;
    }
}

