/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.IOException;
import java.io.InputStream;

public class LookaheadInputStream
extends InputStream {
    private InputStream stream;
    private final byte[] buffer;
    private int buffered = 0;
    private int position = 0;
    private int mark = 0;

    public LookaheadInputStream(InputStream inputStream, int n) {
        this.stream = inputStream;
        this.buffer = new byte[n];
        if (inputStream != null) {
            inputStream.mark(n);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.reset();
            this.stream = null;
        }
    }

    private void fill() throws IOException {
        if (this.available() == 0 && this.buffered < this.buffer.length && this.stream != null) {
            int n = this.stream.read(this.buffer, this.buffered, this.buffer.length - this.buffered);
            if (n != -1) {
                this.buffered += n;
            } else {
                this.close();
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.fill();
        if (this.buffered > this.position) {
            return 0xFF & this.buffer[this.position++];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.fill();
        if (this.buffered > this.position) {
            n2 = Math.min(n2, this.buffered - this.position);
            System.arraycopy(this.buffer, this.position, byArray, n, n2);
            this.position += n2;
            return n2;
        }
        return -1;
    }

    @Override
    public long skip(long l) throws IOException {
        this.fill();
        l = Math.min(l, (long)this.available());
        this.position = (int)((long)this.position + l);
        return l;
    }

    @Override
    public int available() {
        return this.buffered - this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int n) {
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() {
        this.position = this.mark;
    }
}

