/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tika.language.ProfilingWriter;

@Deprecated
public class LanguageProfile {
    public static final int DEFAULT_NGRAM_LENGTH = 3;
    private final int length;
    private final Map<String, Counter> ngrams = new HashMap<String, Counter>();
    private Interleaved interleaved = new Interleaved();
    public static boolean useInterleaved = true;
    private long count = 0L;

    public LanguageProfile(int n) {
        this.length = n;
    }

    public LanguageProfile() {
        this(3);
    }

    public LanguageProfile(String string, int n) {
        this(n);
        ProfilingWriter profilingWriter = new ProfilingWriter(this);
        char[] cArray = string.toCharArray();
        profilingWriter.write(cArray, 0, cArray.length);
    }

    public LanguageProfile(String string) {
        this(string, 3);
    }

    public long getCount() {
        return this.count;
    }

    public long getCount(String string) {
        Counter counter = this.ngrams.get(string);
        if (counter != null) {
            return counter.count;
        }
        return 0L;
    }

    public void add(String string) {
        this.add(string, 1L);
    }

    public void add(String string, long l) {
        if (this.length != string.length()) {
            throw new IllegalArgumentException("Unable to add an ngram of incorrect length: " + string.length() + " != " + this.length);
        }
        Counter counter = this.ngrams.get(string);
        if (counter == null) {
            counter = new Counter();
            this.ngrams.put(string, counter);
        }
        counter.count += l;
        this.count += l;
    }

    public double distance(LanguageProfile languageProfile) {
        return useInterleaved ? this.distanceInterleaved(languageProfile) : this.distanceStandard(languageProfile);
    }

    private double distanceStandard(LanguageProfile languageProfile) {
        if (this.length != languageProfile.length) {
            throw new IllegalArgumentException("Unable to calculage distance of language profiles with different ngram lengths: " + languageProfile.length + " != " + this.length);
        }
        double d = 0.0;
        double d2 = Math.max((double)this.count, 1.0);
        double d3 = Math.max((double)languageProfile.count, 1.0);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.ngrams.keySet());
        hashSet.addAll(languageProfile.ngrams.keySet());
        for (String string : hashSet) {
            double d4 = (double)this.getCount(string) / d2;
            double d5 = (double)languageProfile.getCount(string) / d3;
            double d6 = d4 - d5;
            d += d6 * d6;
        }
        return Math.sqrt(d);
    }

    public String toString() {
        return this.ngrams.toString();
    }

    private double distanceInterleaved(LanguageProfile languageProfile) {
        if (this.length != languageProfile.length) {
            throw new IllegalArgumentException("Unable to calculage distance of language profiles with different ngram lengths: " + languageProfile.length + " != " + this.length);
        }
        double d = 0.0;
        double d2 = Math.max((double)this.count, 1.0);
        double d3 = Math.max((double)languageProfile.count, 1.0);
        Interleaved.Entry entry = this.updateInterleaved().firstEntry();
        Interleaved.Entry entry2 = languageProfile.updateInterleaved().firstEntry();
        while (entry.hasNgram() || entry2.hasNgram()) {
            if (!entry.hasNgram()) {
                d += this.square((double)entry2.count / d3);
                entry2.next();
                continue;
            }
            if (!entry2.hasNgram()) {
                d += this.square((double)entry.count / d2);
                entry.next();
                continue;
            }
            int n = entry.compareTo(entry2);
            if (n == 0) {
                double d4 = (double)entry.count / d2 - (double)entry2.count / d3;
                d += this.square(d4);
                entry.next();
                entry2.next();
                continue;
            }
            if (n < 0) {
                d += this.square((double)entry.count / d2);
                entry.next();
                continue;
            }
            d += this.square((double)entry2.count / d3);
            entry2.next();
        }
        return Math.sqrt(d);
    }

    private double square(double d) {
        return d * d;
    }

    private Interleaved updateInterleaved() {
        this.interleaved.update();
        return this.interleaved;
    }

    private class Interleaved {
        private char[] entries = null;
        private int size = 0;
        private long entriesGeneratedAtCount = -1L;

        private Interleaved() {
        }

        public void update() {
            if (LanguageProfile.this.count == this.entriesGeneratedAtCount) {
                return;
            }
            this.size = LanguageProfile.this.ngrams.size();
            int n = (LanguageProfile.this.length + 2) * this.size;
            if (this.entries == null || this.entries.length < n) {
                this.entries = new char[n];
            }
            int n2 = 0;
            for (Map.Entry<String, Counter> entry : this.getSortedNgrams()) {
                for (int i = 0; i < LanguageProfile.this.length; ++i) {
                    this.entries[n2 + i] = entry.getKey().charAt(i);
                }
                this.entries[n2 + LanguageProfile.this.length] = (char)(entry.getValue().count / 65536L);
                this.entries[n2 + LanguageProfile.this.length + 1] = (char)(entry.getValue().count % 65536L);
                n2 += LanguageProfile.this.length + 2;
            }
            this.entriesGeneratedAtCount = LanguageProfile.this.count;
        }

        public Entry firstEntry() {
            Entry entry = new Entry();
            if (this.size > 0) {
                entry.update(0);
            }
            return entry;
        }

        private List<Map.Entry<String, Counter>> getSortedNgrams() {
            ArrayList<Map.Entry<String, Counter>> arrayList = new ArrayList<Map.Entry<String, Counter>>(LanguageProfile.this.ngrams.size());
            arrayList.addAll(LanguageProfile.this.ngrams.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<String, Counter>>(){

                @Override
                public int compare(Map.Entry<String, Counter> entry, Map.Entry<String, Counter> entry2) {
                    return entry.getKey().compareTo(entry2.getKey());
                }
            });
            return arrayList;
        }

        private class Entry
        implements Comparable<Entry> {
            char[] ngram;
            int count;
            int pos;

            private Entry() {
                this.ngram = new char[LanguageProfile.this.length];
                this.count = 0;
                this.pos = 0;
            }

            private void update(int n) {
                this.pos = n;
                if (n >= Interleaved.this.size) {
                    return;
                }
                int n2 = n * (LanguageProfile.this.length + 2);
                System.arraycopy(Interleaved.this.entries, n2, this.ngram, 0, LanguageProfile.this.length);
                this.count = Interleaved.this.entries[n2 + LanguageProfile.this.length] * 65536 + Interleaved.this.entries[n2 + LanguageProfile.this.length + 1];
            }

            @Override
            public int compareTo(Entry entry) {
                for (int i = 0; i < this.ngram.length; ++i) {
                    if (this.ngram[i] == entry.ngram[i]) continue;
                    return this.ngram[i] - entry.ngram[i];
                }
                return 0;
            }

            public boolean hasNext() {
                return this.pos < Interleaved.this.size - 1;
            }

            public boolean hasNgram() {
                return this.pos < Interleaved.this.size;
            }

            public void next() {
                this.update(this.pos + 1);
            }

            public String toString() {
                return new String(this.ngram) + "(" + this.count + ")";
            }
        }
    }

    private static class Counter {
        private long count = 0L;

        private Counter() {
        }

        public String toString() {
            return Long.toString(this.count);
        }
    }
}

