/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.detect;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.language.detect.LanguageResult;

public abstract class LanguageDetector {
    private static final ServiceLoader DEFAULT_SERVICE_LOADER = new ServiceLoader();
    protected boolean mixedLanguages = false;
    protected boolean shortText = false;

    public static LanguageDetector getDefaultLanguageDetector() {
        List<LanguageDetector> list = LanguageDetector.getLanguageDetectors();
        if (list.isEmpty()) {
            throw new IllegalStateException("No language detectors available");
        }
        return list.get(0);
    }

    public static List<LanguageDetector> getLanguageDetectors() {
        return LanguageDetector.getLanguageDetectors(DEFAULT_SERVICE_LOADER);
    }

    public static List<LanguageDetector> getLanguageDetectors(ServiceLoader serviceLoader) {
        List<LanguageDetector> list = serviceLoader.loadStaticServiceProviders(LanguageDetector.class);
        Collections.sort(list, new Comparator<LanguageDetector>(){

            @Override
            public int compare(LanguageDetector languageDetector, LanguageDetector languageDetector2) {
                boolean bl;
                String string = languageDetector.getClass().getName();
                String string2 = languageDetector2.getClass().getName();
                boolean bl2 = string.startsWith("org.apache.tika.");
                if (bl2 == (bl = string2.startsWith("org.apache.tika."))) {
                    return string.compareTo(string2);
                }
                if (bl2) {
                    return -1;
                }
                return 1;
            }
        });
        return list;
    }

    public boolean isMixedLanguages() {
        return this.mixedLanguages;
    }

    public LanguageDetector setMixedLanguages(boolean bl) {
        this.mixedLanguages = bl;
        return this;
    }

    public boolean isShortText() {
        return this.shortText;
    }

    public LanguageDetector setShortText(boolean bl) {
        this.shortText = bl;
        return this;
    }

    public abstract LanguageDetector loadModels() throws IOException;

    public abstract LanguageDetector loadModels(Set<String> var1) throws IOException;

    public abstract boolean hasModel(String var1);

    public abstract LanguageDetector setPriors(Map<String, Float> var1) throws IOException;

    public abstract void reset();

    public abstract void addText(char[] var1, int var2, int var3);

    public void addText(CharSequence charSequence) {
        char[] cArray = charSequence.toString().toCharArray();
        this.addText(cArray, 0, cArray.length);
    }

    public boolean hasEnoughText() {
        return false;
    }

    public abstract List<LanguageResult> detectAll();

    public LanguageResult detect() {
        List<LanguageResult> list = this.detectAll();
        return list.get(0);
    }

    public List<LanguageResult> detectAll(String string) {
        this.reset();
        this.addText(string);
        return this.detectAll();
    }

    public LanguageResult detect(CharSequence charSequence) {
        this.reset();
        this.addText(charSequence);
        return this.detect();
    }
}

