/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.tika.metadata.ClimateForcast;
import org.apache.tika.metadata.CreativeCommons;
import org.apache.tika.metadata.Geographic;
import org.apache.tika.metadata.HttpHeaders;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.PropertyTypeException;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaMetadataKeys;
import org.apache.tika.metadata.TikaMimeKeys;
import org.apache.tika.utils.DateUtils;

public class Metadata
implements CreativeCommons,
Geographic,
HttpHeaders,
Message,
MSOffice,
ClimateForcast,
TIFF,
TikaMetadataKeys,
TikaMimeKeys,
Serializable {
    private static final long serialVersionUID = 5623926545693153182L;
    private Map<String, String[]> metadata = new HashMap<String, String[]>();
    public static final String NAMESPACE_PREFIX_DELIMITER = ":";
    public static final String FORMAT = "format";
    public static final String IDENTIFIER = "identifier";
    public static final String MODIFIED = "modified";
    public static final String CONTRIBUTOR = "contributor";
    public static final String COVERAGE = "coverage";
    public static final String CREATOR = "creator";
    public static final Property DATE = Property.internalDate("date");
    public static final String DESCRIPTION = "description";
    public static final String LANGUAGE = "language";
    public static final String PUBLISHER = "publisher";
    public static final String RELATION = "relation";
    public static final String RIGHTS = "rights";
    public static final String SOURCE = "source";
    public static final String SUBJECT = "subject";
    public static final String TITLE = "title";
    public static final String TYPE = "type";
    private static final DateFormat[] iso8601InputFormats = new DateFormat[]{Metadata.createDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", DateUtils.UTC), Metadata.createDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", null), Metadata.createDateFormat("yyyy-MM-dd'T'HH:mm:ss", null), Metadata.createDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'", DateUtils.UTC), Metadata.createDateFormat("yyyy-MM-dd' 'HH:mm:ssZ", null), Metadata.createDateFormat("yyyy-MM-dd' 'HH:mm:ss", null), Metadata.createDateFormat("yyyy-MM-dd", DateUtils.MIDDAY), Metadata.createDateFormat("yyyy:MM:dd", DateUtils.MIDDAY)};

    private static DateFormat createDateFormat(String string, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, new DateFormatSymbols(Locale.US));
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat;
    }

    private static synchronized Date parseDate(String object) {
        int n = ((String)object).length();
        if (((String)object).charAt(n - 3) == ':' && (((String)object).charAt(n - 6) == '+' || ((String)object).charAt(n - 6) == '-')) {
            object = ((String)object).substring(0, n - 3) + ((String)object).substring(n - 2);
        }
        for (DateFormat dateFormat : iso8601InputFormats) {
            try {
                return dateFormat.parse((String)object);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public boolean isMultiValued(Property property) {
        return this.metadata.get(property.getName()) != null && this.metadata.get(property.getName()).length > 1;
    }

    public boolean isMultiValued(String string) {
        return this.metadata.get(string) != null && this.metadata.get(string).length > 1;
    }

    public String[] names() {
        return this.metadata.keySet().toArray(new String[this.metadata.keySet().size()]);
    }

    public String get(String string) {
        String[] stringArray = this.metadata.get(string);
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public String get(Property property) {
        return this.get(property.getName());
    }

    public Integer getInt(Property property) {
        if (property.getPrimaryProperty().getPropertyType() != Property.PropertyType.SIMPLE) {
            return null;
        }
        if (property.getPrimaryProperty().getValueType() != Property.ValueType.INTEGER) {
            return null;
        }
        String string = this.get(property);
        if (string == null) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Date getDate(Property property) {
        if (property.getPrimaryProperty().getPropertyType() != Property.PropertyType.SIMPLE) {
            return null;
        }
        if (property.getPrimaryProperty().getValueType() != Property.ValueType.DATE) {
            return null;
        }
        String string = this.get(property);
        if (string != null) {
            return Metadata.parseDate(string);
        }
        return null;
    }

    public String[] getValues(Property property) {
        return this._getValues(property.getName());
    }

    public String[] getValues(String string) {
        return this._getValues(string);
    }

    private String[] _getValues(String string) {
        String[] stringArray = this.metadata.get(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] appendedValues(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public void add(String string, String string2) {
        String[] stringArray = this.metadata.get(string);
        if (stringArray == null) {
            this.set(string, string2);
        } else {
            this.metadata.put(string, this.appendedValues(stringArray, string2));
        }
    }

    public void add(Property property, String string) {
        String[] stringArray = this.metadata.get(property.getName());
        if (stringArray == null) {
            this.set(property, string);
        } else if (property.isMultiValuePermitted()) {
            this.set(property, this.appendedValues(stringArray, string));
        } else {
            throw new PropertyTypeException(property.getName() + " : " + property.getPropertyType());
        }
    }

    public void setAll(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.metadata.put(string, new String[]{properties.getProperty(string)});
        }
    }

    public void set(String string, String string2) {
        if (string2 != null) {
            this.metadata.put(string, new String[]{string2});
        } else {
            this.metadata.remove(string);
        }
    }

    public void set(Property property, String string) {
        if (property == null) {
            throw new NullPointerException("property must not be null");
        }
        if (property.getPropertyType() == Property.PropertyType.COMPOSITE) {
            this.set(property.getPrimaryProperty(), string);
            if (property.getSecondaryExtractProperties() != null) {
                for (Property property2 : property.getSecondaryExtractProperties()) {
                    this.set(property2, string);
                }
            }
        } else {
            this.set(property.getName(), string);
        }
    }

    public void set(Property property, String[] stringArray) {
        if (property == null) {
            throw new NullPointerException("property must not be null");
        }
        if (property.getPropertyType() == Property.PropertyType.COMPOSITE) {
            this.set(property.getPrimaryProperty(), stringArray);
            if (property.getSecondaryExtractProperties() != null) {
                for (Property property2 : property.getSecondaryExtractProperties()) {
                    this.set(property2, stringArray);
                }
            }
        } else {
            this.metadata.put(property.getName(), stringArray);
        }
    }

    public void set(Property property, int n) {
        if (property.getPrimaryProperty().getPropertyType() != Property.PropertyType.SIMPLE) {
            throw new PropertyTypeException(Property.PropertyType.SIMPLE, property.getPrimaryProperty().getPropertyType());
        }
        if (property.getPrimaryProperty().getValueType() != Property.ValueType.INTEGER) {
            throw new PropertyTypeException(Property.ValueType.INTEGER, property.getPrimaryProperty().getValueType());
        }
        this.set(property, Integer.toString(n));
    }

    public void set(Property property, double d) {
        if (property.getPrimaryProperty().getPropertyType() != Property.PropertyType.SIMPLE) {
            throw new PropertyTypeException(Property.PropertyType.SIMPLE, property.getPrimaryProperty().getPropertyType());
        }
        if (property.getPrimaryProperty().getValueType() != Property.ValueType.REAL && property.getPrimaryProperty().getValueType() != Property.ValueType.RATIONAL) {
            throw new PropertyTypeException(Property.ValueType.REAL, property.getPrimaryProperty().getValueType());
        }
        this.set(property, Double.toString(d));
    }

    public void set(Property property, Date date) {
        if (property.getPrimaryProperty().getPropertyType() != Property.PropertyType.SIMPLE) {
            throw new PropertyTypeException(Property.PropertyType.SIMPLE, property.getPrimaryProperty().getPropertyType());
        }
        if (property.getPrimaryProperty().getValueType() != Property.ValueType.DATE) {
            throw new PropertyTypeException(Property.ValueType.DATE, property.getPrimaryProperty().getValueType());
        }
        String string = null;
        if (date != null) {
            string = DateUtils.formatDate(date);
        }
        this.set(property, string);
    }

    public void set(Property property, Calendar calendar) {
        if (property.getPrimaryProperty().getPropertyType() != Property.PropertyType.SIMPLE) {
            throw new PropertyTypeException(Property.PropertyType.SIMPLE, property.getPrimaryProperty().getPropertyType());
        }
        if (property.getPrimaryProperty().getValueType() != Property.ValueType.DATE) {
            throw new PropertyTypeException(Property.ValueType.DATE, property.getPrimaryProperty().getValueType());
        }
        String string = null;
        if (calendar != null) {
            string = DateUtils.formatDate(calendar);
        }
        this.set(property, string);
    }

    public void remove(String string) {
        this.metadata.remove(string);
    }

    public int size() {
        return this.metadata.size();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Metadata metadata = null;
        try {
            metadata = (Metadata)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (metadata.size() != this.size()) {
            return false;
        }
        String[] stringArray = this.names();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            String[] stringArray3 = metadata._getValues(stringArray[i]);
            if (stringArray3.length != (stringArray2 = this._getValues(stringArray[i])).length) {
                return false;
            }
            for (int j = 0; j < stringArray3.length; ++j) {
                if (stringArray3[j].equals(stringArray2[j])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.names();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this._getValues(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                stringBuffer.append(stringArray[i]).append("=").append(stringArray2[j]).append(" ");
            }
        }
        return stringBuffer.toString();
    }
}

