/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tika.metadata.PropertyTypeException;

public final class Property
implements Comparable<Property> {
    private static final Map<String, Property> properties = new HashMap<String, Property>();
    private final String name;
    private final boolean internal;
    private final PropertyType propertyType;
    private final ValueType valueType;
    private final Property primaryProperty;
    private final Property[] secondaryExtractProperties;
    private final Set<String> choices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property(String string, boolean bl, PropertyType propertyType, ValueType valueType, String[] stringArray, Property property, Property[] propertyArray) {
        this.name = string;
        this.internal = bl;
        this.propertyType = propertyType;
        this.valueType = valueType;
        this.choices = stringArray != null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList((String[])stringArray.clone()))) : null;
        if (property != null) {
            this.primaryProperty = property;
            this.secondaryExtractProperties = propertyArray;
        } else {
            this.primaryProperty = this;
            this.secondaryExtractProperties = null;
            Map<String, Property> map = properties;
            synchronized (map) {
                properties.put(string, this);
            }
        }
    }

    private Property(String string, boolean bl, PropertyType propertyType, ValueType valueType, String[] stringArray) {
        this(string, bl, propertyType, valueType, stringArray, null, null);
    }

    private Property(String string, boolean bl, ValueType valueType, String[] stringArray) {
        this(string, bl, PropertyType.SIMPLE, valueType, stringArray);
    }

    private Property(String string, boolean bl, ValueType valueType) {
        this(string, bl, PropertyType.SIMPLE, valueType, null);
    }

    private Property(String string, boolean bl, PropertyType propertyType, ValueType valueType) {
        this(string, bl, propertyType, valueType, null);
    }

    public String getName() {
        return this.name;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isExternal() {
        return !this.internal;
    }

    public boolean isMultiValuePermitted() {
        if (this.propertyType == PropertyType.BAG || this.propertyType == PropertyType.SEQ || this.propertyType == PropertyType.ALT) {
            return true;
        }
        if (this.propertyType == PropertyType.COMPOSITE) {
            return this.primaryProperty.isMultiValuePermitted();
        }
        return false;
    }

    public static PropertyType getPropertyType(String string) {
        PropertyType propertyType = null;
        Property property = properties.get(string);
        if (property != null) {
            propertyType = property.getPropertyType();
        }
        return propertyType;
    }

    public static Property get(String string) {
        return properties.get(string);
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Set<String> getChoices() {
        return this.choices;
    }

    public Property getPrimaryProperty() {
        return this.primaryProperty;
    }

    public Property[] getSecondaryExtractProperties() {
        return this.secondaryExtractProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<Property> getProperties(String string) {
        TreeSet<Property> treeSet = new TreeSet<Property>();
        String string2 = string + ":";
        Map<String, Property> map = properties;
        synchronized (map) {
            for (String string3 : properties.keySet()) {
                if (!string3.startsWith(string2)) continue;
                treeSet.add(properties.get(string3));
            }
        }
        return treeSet;
    }

    public static Property internalBoolean(String string) {
        return new Property(string, true, ValueType.BOOLEAN);
    }

    public static Property internalClosedChoise(String string, String ... stringArray) {
        return new Property(string, true, ValueType.CLOSED_CHOICE, stringArray);
    }

    public static Property internalDate(String string) {
        return new Property(string, true, ValueType.DATE);
    }

    public static Property internalInteger(String string) {
        return new Property(string, true, ValueType.INTEGER);
    }

    public static Property internalIntegerSequence(String string) {
        return new Property(string, true, PropertyType.SEQ, ValueType.INTEGER);
    }

    public static Property internalRational(String string) {
        return new Property(string, true, ValueType.RATIONAL);
    }

    public static Property internalOpenChoise(String string, String ... stringArray) {
        return new Property(string, true, ValueType.OPEN_CHOICE, stringArray);
    }

    public static Property internalReal(String string) {
        return new Property(string, true, ValueType.REAL);
    }

    public static Property internalText(String string) {
        return new Property(string, true, ValueType.TEXT);
    }

    public static Property internalTextBag(String string) {
        return new Property(string, true, PropertyType.BAG, ValueType.TEXT);
    }

    public static Property internalURI(String string) {
        return new Property(string, true, ValueType.URI);
    }

    public static Property externalClosedChoise(String string, String ... stringArray) {
        return new Property(string, false, ValueType.CLOSED_CHOICE, stringArray);
    }

    public static Property externalOpenChoise(String string, String ... stringArray) {
        return new Property(string, false, ValueType.OPEN_CHOICE, stringArray);
    }

    public static Property externalDate(String string) {
        return new Property(string, false, ValueType.DATE);
    }

    public static Property externalReal(String string) {
        return new Property(string, false, ValueType.REAL);
    }

    public static Property externalInteger(String string) {
        return new Property(string, false, ValueType.INTEGER);
    }

    public static Property externalBoolean(String string) {
        return new Property(string, false, ValueType.BOOLEAN);
    }

    public static Property externalText(String string) {
        return new Property(string, false, ValueType.TEXT);
    }

    public static Property externalTextBag(String string) {
        return new Property(string, false, PropertyType.BAG, ValueType.TEXT);
    }

    public static Property composite(Property property, Property[] propertyArray) {
        if (property == null) {
            throw new NullPointerException("primaryProperty must not be null");
        }
        if (property.getPropertyType() == PropertyType.COMPOSITE) {
            throw new PropertyTypeException(property.getPropertyType());
        }
        if (propertyArray != null) {
            for (Property property2 : propertyArray) {
                if (property2.getPropertyType() != PropertyType.COMPOSITE) continue;
                throw new PropertyTypeException(property2.getPropertyType());
            }
        }
        Object[] objectArray = null;
        if (property.getChoices() != null) {
            objectArray = property.getChoices().toArray(new String[property.getChoices().size()]);
        }
        return new Property(property.getName(), property.isInternal(), PropertyType.COMPOSITE, ValueType.PROPERTY, (String[])objectArray, property, propertyArray);
    }

    @Override
    public int compareTo(Property property) {
        return this.name.compareTo(property.name);
    }

    public boolean equals(Object object) {
        return object instanceof Property && this.name.equals(((Property)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum PropertyType {
        SIMPLE,
        STRUCTURE,
        BAG,
        SEQ,
        ALT,
        COMPOSITE;

    }

    public static enum ValueType {
        BOOLEAN,
        OPEN_CHOICE,
        CLOSED_CHOICE,
        DATE,
        INTEGER,
        LOCALE,
        MIME_TYPE,
        PROPER_NAME,
        RATIONAL,
        REAL,
        TEXT,
        URI,
        URL,
        XPATH,
        PROPERTY;

    }
}

