/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.Arrays;
import org.apache.tika.mime.Clause;

class AndClause
implements Clause {
    private final Clause[] clauses;

    AndClause(Clause ... clauseArray) {
        this.clauses = clauseArray;
    }

    @Override
    public boolean eval(byte[] byArray) {
        for (Clause clause : this.clauses) {
            if (clause.eval(byArray)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        int n = 0;
        for (Clause clause : this.clauses) {
            n += clause.size();
        }
        return n;
    }

    public String toString() {
        return "and" + Arrays.toString(this.clauses);
    }
}

