/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tika.Tika;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TextDetector;
import org.apache.tika.detect.XmlRootExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.mime.Patterns;

public final class MimeTypes
implements Detector,
Serializable {
    private static final long serialVersionUID = -1350863170146349036L;
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final String PLAIN_TEXT = "text/plain";
    public static final String XML = "application/xml";
    private final MimeType rootMimeType;
    private final List<MimeType> rootMimeTypeL;
    private final MimeType textMimeType;
    private final MimeType xmlMimeType;
    private final MediaTypeRegistry registry = new MediaTypeRegistry();
    private final Map<MediaType, MimeType> types = new HashMap<MediaType, MimeType>();
    private Patterns patterns = new Patterns(this.registry);
    private final List<Magic> magics = new ArrayList<Magic>();
    private final List<MimeType> xmls = new ArrayList<MimeType>();
    private static MimeTypes DEFAULT_TYPES = null;
    private static Map<ClassLoader, MimeTypes> CLASSLOADER_SPECIFIC_DEFAULT_TYPES = new HashMap<ClassLoader, MimeTypes>();

    public MimeTypes() {
        this.rootMimeType = new MimeType(MediaType.OCTET_STREAM);
        this.textMimeType = new MimeType(MediaType.TEXT_PLAIN);
        this.xmlMimeType = new MimeType(MediaType.APPLICATION_XML);
        this.rootMimeTypeL = Collections.singletonList(this.rootMimeType);
        this.add(this.rootMimeType);
        this.add(this.textMimeType);
        this.add(this.xmlMimeType);
    }

    public MimeType getMimeType(String string) {
        MimeType mimeType = this.patterns.matches(string);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = this.patterns.matches(string.toLowerCase(Locale.ENGLISH));
        if (mimeType != null) {
            return mimeType;
        }
        return this.rootMimeType;
    }

    public MimeType getMimeType(File file) throws MimeTypeException, IOException {
        return this.forName(new Tika(this).detect(file));
    }

    List<MimeType> getMimeType(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Data is missing");
        }
        if (byArray.length == 0) {
            return this.rootMimeTypeL;
        }
        ArrayList<MimeType> arrayList = new ArrayList<MimeType>(1);
        int n = -1;
        for (Magic object2 : this.magics) {
            if (n > 0 && n > object2.getPriority()) break;
            if (!object2.eval(byArray)) continue;
            arrayList.add(object2.getType());
            n = object2.getPriority();
        }
        if (!arrayList.isEmpty()) {
            block3: for (int i = 0; i < arrayList.size(); ++i) {
                MimeType mimeType = (MimeType)arrayList.get(i);
                if (!XML.equals(mimeType.getName()) && !"text/html".equals(mimeType.getName())) continue;
                XmlRootExtractor xmlRootExtractor = new XmlRootExtractor();
                QName qName = xmlRootExtractor.extractRootElement(byArray);
                if (qName != null) {
                    for (MimeType mimeType2 : this.xmls) {
                        if (!mimeType2.matchesXML(qName.getNamespaceURI(), qName.getLocalPart())) continue;
                        arrayList.set(i, mimeType2);
                        continue block3;
                    }
                    continue;
                }
                if (!XML.equals(mimeType.getName())) continue;
                arrayList.set(i, this.textMimeType);
            }
            return arrayList;
        }
        try {
            TextDetector textDetector = new TextDetector(this.getMinLength());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            MimeType mimeType = this.forName(textDetector.detect(byteArrayInputStream, new Metadata()).toString());
            return Collections.singletonList(mimeType);
        }
        catch (Exception exception) {
            return this.rootMimeTypeL;
        }
    }

    byte[] readMagicHeader(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream is missing");
        }
        byte[] byArray = new byte[this.getMinLength()];
        int n = 0;
        int n2 = inputStream.read(byArray);
        while (n2 != -1) {
            if ((n += n2) == byArray.length) {
                return byArray;
            }
            n2 = inputStream.read(byArray, n, byArray.length - n);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeType forName(String string) throws MimeTypeException {
        MediaType mediaType = MediaType.parse(string);
        if (mediaType != null) {
            MediaType mediaType2 = this.registry.normalize(mediaType);
            MimeType mimeType = this.types.get(mediaType2);
            if (mimeType == null) {
                MimeTypes mimeTypes = this;
                synchronized (mimeTypes) {
                    mimeType = this.types.get(mediaType2);
                    if (mimeType == null) {
                        mimeType = new MimeType(mediaType);
                        this.add(mimeType);
                        this.types.put(mediaType, mimeType);
                    }
                }
            }
            return mimeType;
        }
        throw new MimeTypeException("Invalid media type name: " + string);
    }

    public MimeType getRegisteredMimeType(String string) throws MimeTypeException {
        MediaType mediaType = MediaType.parse(string);
        if (mediaType != null) {
            MediaType mediaType2 = this.registry.normalize(mediaType);
            MimeType mimeType = this.types.get(mediaType2);
            if (mimeType != null) {
                return mimeType;
            }
            if (mediaType2.hasParameters()) {
                return this.types.get(mediaType2.getBaseType());
            }
            return null;
        }
        throw new MimeTypeException("Invalid media type name: " + string);
    }

    public synchronized void setSuperType(MimeType mimeType, MediaType mediaType) {
        this.registry.addSuperType(mimeType.getType(), mediaType);
    }

    synchronized void addAlias(MimeType mimeType, MediaType mediaType) {
        this.registry.addAlias(mimeType.getType(), mediaType);
    }

    public void addPattern(MimeType mimeType, String string) throws MimeTypeException {
        this.addPattern(mimeType, string, false);
    }

    public void addPattern(MimeType mimeType, String string, boolean bl) throws MimeTypeException {
        this.patterns.add(string, bl, mimeType);
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.registry;
    }

    public int getMinLength() {
        return 65536;
    }

    void add(MimeType mimeType) {
        this.registry.addType(mimeType.getType());
        this.types.put(mimeType.getType(), mimeType);
        if (mimeType.hasMagic()) {
            this.magics.addAll(mimeType.getMagics());
        }
        if (mimeType.hasRootXML()) {
            this.xmls.add(mimeType);
        }
    }

    void init() {
        for (MimeType mimeType : this.types.values()) {
            this.magics.addAll(mimeType.getMagics());
            if (!mimeType.hasRootXML()) continue;
            this.xmls.add(mimeType);
        }
        Collections.sort(this.magics);
        Collections.sort(this.xmls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
        Comparable<URI> comparable;
        Object object;
        Object object2;
        List<MimeType> list = null;
        if (inputStream != null) {
            inputStream.mark(this.getMinLength());
            try {
                object2 = this.readMagicHeader(inputStream);
                list = this.getMimeType((byte[])object2);
            }
            finally {
                inputStream.reset();
            }
        }
        if ((object2 = metadata.get("resourceName")) != null) {
            object = null;
            try {
                int n;
                comparable = new URI((String)object2);
                String string = comparable.getPath();
                if (string != null && (n = string.lastIndexOf(47)) + 1 < string.length()) {
                    object = string.substring(n + 1);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                object = object2;
            }
            if (object != null) {
                comparable = this.getMimeType((String)object);
                list = this.applyHint(list, (MimeType)comparable);
            }
        }
        if ((object = metadata.get("Content-Type")) != null) {
            try {
                comparable = this.forName((String)object);
                list = this.applyHint(list, (MimeType)comparable);
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
        }
        if (list == null || list.isEmpty()) {
            return MediaType.OCTET_STREAM;
        }
        return list.get(0).getType();
    }

    private List<MimeType> applyHint(List<MimeType> list, MimeType mimeType) {
        if (list == null || list.isEmpty()) {
            return Collections.singletonList(mimeType);
        }
        for (int i = 0; i < list.size(); ++i) {
            MimeType mimeType2 = list.get(i);
            if (!mimeType.equals(mimeType2) && !this.registry.isSpecializationOf(mimeType.getType(), mimeType2.getType())) continue;
            return Collections.singletonList(mimeType);
        }
        return list;
    }

    public static synchronized MimeTypes getDefaultMimeTypes() {
        return MimeTypes.getDefaultMimeTypes(null);
    }

    public static synchronized MimeTypes getDefaultMimeTypes(ClassLoader classLoader) {
        MimeTypes mimeTypes = DEFAULT_TYPES;
        if (classLoader != null) {
            mimeTypes = CLASSLOADER_SPECIFIC_DEFAULT_TYPES.get(classLoader);
        }
        if (mimeTypes == null) {
            try {
                mimeTypes = MimeTypesFactory.create("tika-mimetypes.xml", "custom-mimetypes.xml", classLoader);
            }
            catch (MimeTypeException mimeTypeException) {
                throw new RuntimeException("Unable to parse the default media type registry", mimeTypeException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read the default media type registry", iOException);
            }
            if (classLoader == null) {
                DEFAULT_TYPES = mimeTypes;
            } else {
                CLASSLOADER_SPECIFIC_DEFAULT_TYPES.put(classLoader, mimeTypes);
            }
        }
        return mimeTypes;
    }
}

