/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.tika.mime.AndClause;
import org.apache.tika.mime.Clause;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MagicMatch;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReaderMetKeys;
import org.apache.tika.mime.OrClause;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MimeTypesReader
extends DefaultHandler
implements MimeTypesReaderMetKeys {
    protected final MimeTypes types;
    protected MimeType type = null;
    protected int priority;
    protected StringBuilder characters = null;
    private ClauseRecord current = new ClauseRecord(null);

    protected MimeTypesReader(MimeTypes mimeTypes) {
        this.types = mimeTypes;
    }

    public void read(InputStream inputStream) throws IOException, MimeTypeException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MimeTypeException("Unable to create an XML parser", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new MimeTypeException("Invalid type configuration", sAXException);
        }
    }

    public void read(Document document) throws MimeTypeException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(document), new SAXResult(this));
        }
        catch (TransformerException transformerException) {
            throw new MimeTypeException("Failed to parse type registry", transformerException);
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.type == null) {
            if ("mime-type".equals(string3)) {
                String string4 = attributes.getValue("type");
                try {
                    this.type = this.types.forName(string4);
                }
                catch (MimeTypeException mimeTypeException) {
                    this.handleMimeError(string4, mimeTypeException, string3, attributes);
                }
            }
        } else if ("alias".equals(string3)) {
            String string5 = attributes.getValue("type");
            this.types.addAlias(this.type, MediaType.parse(string5));
        } else if ("sub-class-of".equals(string3)) {
            String string6 = attributes.getValue("type");
            this.types.setSuperType(this.type, MediaType.parse(string6));
        } else if ("acronym".equals(string3) || "_comment".equals(string3) || "tika:link".equals(string3) || "tika:uti".equals(string3)) {
            this.characters = new StringBuilder();
        } else if ("glob".equals(string3)) {
            String string7 = attributes.getValue("pattern");
            String string8 = attributes.getValue("isregex");
            if (string7 != null) {
                try {
                    this.types.addPattern(this.type, string7, Boolean.valueOf(string8));
                }
                catch (MimeTypeException mimeTypeException) {
                    this.handleGlobError(this.type, string7, mimeTypeException, string3, attributes);
                }
            }
        } else if ("root-XML".equals(string3)) {
            String string9 = attributes.getValue("namespaceURI");
            String string10 = attributes.getValue("localName");
            this.type.addRootXML(string9, string10);
        } else if ("match".equals(string3)) {
            String string11 = attributes.getValue("type");
            String string12 = attributes.getValue("offset");
            String string13 = attributes.getValue("value");
            String string14 = attributes.getValue("mask");
            if (string11 == null) {
                string11 = "string";
            }
            this.current = new ClauseRecord(new MagicMatch(this.type.getType(), string11, string12, string13, string14));
        } else if ("magic".equals(string3)) {
            String string15 = attributes.getValue("priority");
            this.priority = string15 != null && string15.length() > 0 ? Integer.parseInt(string15) : 50;
            this.current = new ClauseRecord(null);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.type != null) {
            if ("mime-type".equals(string3)) {
                this.type = null;
            } else if ("_comment".equals(string3)) {
                this.type.setDescription(this.characters.toString().trim());
                this.characters = null;
            } else if ("acronym".equals(string3)) {
                this.type.setAcronym(this.characters.toString().trim());
                this.characters = null;
            } else if ("tika:uti".equals(string3)) {
                this.type.setUniformTypeIdentifier(this.characters.toString().trim());
                this.characters = null;
            } else if ("tika:link".equals(string3)) {
                try {
                    this.type.addLink(new URI(this.characters.toString().trim()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("unable to parse link: " + this.characters, uRISyntaxException);
                }
                this.characters = null;
            } else if ("match".equals(string3)) {
                this.current.stop();
            } else if ("magic".equals(string3)) {
                for (Clause clause : this.current.getClauses()) {
                    this.type.addMagic(new Magic(this.type, this.priority, clause));
                }
                this.current = null;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.characters != null) {
            this.characters.append(cArray, n, n2);
        }
    }

    protected void handleMimeError(String string, MimeTypeException mimeTypeException, String string2, Attributes attributes) throws SAXException {
        throw new SAXException(mimeTypeException);
    }

    protected void handleGlobError(MimeType mimeType, String string, MimeTypeException mimeTypeException, String string2, Attributes attributes) throws SAXException {
        throw new SAXException(mimeTypeException);
    }

    private class ClauseRecord {
        private ClauseRecord parent;
        private Clause clause;
        private List<Clause> subclauses = null;

        public ClauseRecord(Clause clause) {
            this.parent = MimeTypesReader.this.current;
            this.clause = clause;
        }

        public void stop() {
            if (this.subclauses != null) {
                Clause clause = this.subclauses.size() == 1 ? this.subclauses.get(0) : new OrClause(this.subclauses);
                this.clause = new AndClause(this.clause, clause);
            }
            if (this.parent.subclauses == null) {
                this.parent.subclauses = Collections.singletonList(this.clause);
            } else {
                if (this.parent.subclauses.size() == 1) {
                    this.parent.subclauses = new ArrayList<Clause>(this.parent.subclauses);
                }
                this.parent.subclauses.add(this.clause);
            }
            MimeTypesReader.this.current = MimeTypesReader.this.current.parent;
        }

        public List<Clause> getClauses() {
            return this.subclauses;
        }
    }
}

