/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;

public class ProbabilisticMimeDetectionSelector
implements Detector {
    private static final long serialVersionUID = 224589862960269260L;
    private MimeTypes mimeTypes;
    private final MediaType rootMediaType;
    private static final float DEFAULT_MAGIC_TRUST = 0.9f;
    private static final float DEFAULT_META_TRUST = 0.8f;
    private static final float DEFAULT_EXTENSION_TRUST = 0.8f;
    private float priorMagicFileType;
    private float priorExtensionFileType;
    private float priorMetaFileType;
    private float magic_trust;
    private float extension_trust;
    private float meta_trust;
    private float magic_neg;
    private float extension_neg;
    private float meta_neg;
    private float threshold;
    private float changeRate;

    public ProbabilisticMimeDetectionSelector() {
        this(MimeTypes.getDefaultMimeTypes(), null);
    }

    public ProbabilisticMimeDetectionSelector(Builder builder) {
        this(MimeTypes.getDefaultMimeTypes(), builder);
    }

    public ProbabilisticMimeDetectionSelector(MimeTypes mimeTypes) {
        this(mimeTypes, null);
    }

    public ProbabilisticMimeDetectionSelector(MimeTypes mimeTypes, Builder builder) {
        this.mimeTypes = mimeTypes;
        this.rootMediaType = MediaType.OCTET_STREAM;
        this.initializeDefaultProbabilityParameters();
        this.changeRate = 0.1f;
        if (builder != null) {
            this.priorMagicFileType = builder.priorMagicFileType == 0.0f ? this.priorMagicFileType : builder.priorMagicFileType;
            this.priorExtensionFileType = builder.priorExtensionFileType == 0.0f ? this.priorExtensionFileType : builder.priorExtensionFileType;
            this.priorMetaFileType = builder.priorMetaFileType == 0.0f ? this.priorMetaFileType : builder.priorMetaFileType;
            this.magic_trust = builder.magic_trust == 0.0f ? this.magic_trust : builder.extension_neg;
            this.extension_trust = builder.extension_trust == 0.0f ? this.extension_trust : builder.extension_trust;
            this.meta_trust = builder.meta_trust == 0.0f ? this.meta_trust : builder.meta_trust;
            this.magic_neg = builder.magic_neg == 0.0f ? this.magic_neg : builder.magic_neg;
            this.extension_neg = builder.extension_neg == 0.0f ? this.extension_neg : builder.extension_neg;
            this.meta_neg = builder.meta_neg == 0.0f ? this.meta_neg : builder.meta_neg;
            this.threshold = builder.threshold == 0.0f ? this.threshold : builder.threshold;
        }
    }

    private void initializeDefaultProbabilityParameters() {
        this.priorMagicFileType = 0.5f;
        this.priorExtensionFileType = 0.5f;
        this.priorMetaFileType = 0.5f;
        this.magic_trust = 0.9f;
        this.extension_trust = 0.8f;
        this.meta_trust = 0.8f;
        this.magic_neg = 0.100000024f;
        this.extension_neg = 0.19999999f;
        this.meta_neg = 0.19999999f;
        this.threshold = 0.5001f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
        Object object;
        Object object2;
        Object object3;
        List<MimeType> list = null;
        if (inputStream != null) {
            inputStream.mark(this.mimeTypes.getMinLength());
            try {
                object3 = this.mimeTypes.readMagicHeader(inputStream);
                list = this.mimeTypes.getMimeType((byte[])object3);
            }
            finally {
                inputStream.reset();
            }
        }
        object3 = null;
        String string = metadata.get("resourceName");
        if (string != null) {
            object2 = null;
            try {
                int n;
                object = new URI(string);
                String string2 = ((URI)object).getPath();
                if (string2 != null && (n = string2.lastIndexOf(47)) + 1 < string2.length()) {
                    object2 = string2.substring(n + 1);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                object2 = string;
            }
            if (object2 != null) {
                object3 = this.mimeTypes.getMimeType((String)object2);
            }
        }
        object2 = null;
        object = metadata.get("Content-Type");
        if (object != null) {
            try {
                object2 = this.mimeTypes.forName((String)object);
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
        }
        return this.applyProbilities(list, (MimeType)object3, (MimeType)object2);
    }

    private MediaType applyProbilities(List<MimeType> list, MimeType mimeType, MimeType mimeType2) {
        MediaType mediaType = mimeType == null ? null : mimeType.getType();
        MediaType mediaType2 = mimeType2 == null ? null : mimeType2.getType();
        int n = list.size();
        float f = this.magic_trust;
        float f2 = this.magic_neg;
        float f3 = this.extension_trust;
        float f4 = this.extension_neg;
        float f5 = this.meta_trust;
        float f6 = this.meta_neg;
        if (mediaType == null || mediaType.compareTo(this.rootMediaType) == 0) {
            f3 = 1.0f;
            f4 = 1.0f;
        }
        if (mediaType2 == null || mediaType2.compareTo(this.rootMediaType) == 0) {
            f5 = 1.0f;
            f6 = 1.0f;
        }
        float f7 = -1.0f;
        MediaType mediaType3 = this.rootMediaType;
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < n; ++i) {
                int n2;
                MediaType mediaType4 = list.get(i).getType();
                MediaTypeRegistry mediaTypeRegistry = this.mimeTypes.getMediaTypeRegistry();
                if (mediaType4 != null && mediaType4.equals(this.rootMediaType)) {
                    f = 1.0f;
                    f2 = 1.0f;
                } else {
                    if (mediaType != null) {
                        if (mediaType.equals(mediaType4) || mediaTypeRegistry.isSpecializationOf(mediaType, mediaType4)) {
                            list.set(i, mimeType);
                        } else if (mediaTypeRegistry.isSpecializationOf(mediaType4, mediaType)) {
                            mediaType = mediaType4;
                        }
                    }
                    if (mediaType2 != null) {
                        if (mediaType2.equals(mediaType4) || mediaTypeRegistry.isSpecializationOf(mediaType2, mediaType4)) {
                            list.set(i, mimeType2);
                        } else if (mediaTypeRegistry.isSpecializationOf(mediaType4, mediaType2)) {
                            mediaType2 = mediaType4;
                        }
                    }
                }
                float[] fArray = new float[3];
                float[] fArray2 = new float[3];
                float[] fArray3 = new float[3];
                mediaType4 = list.get(i).getType();
                if (i > 0) {
                    f *= 1.0f - this.changeRate;
                    f2 *= 1.0f + this.changeRate;
                }
                if (mediaType4 != null && f != 1.0f) {
                    fArray2[0] = f;
                    fArray3[0] = f2;
                    if (mediaType2 != null && f5 != 1.0f) {
                        if (mediaType4.equals(mediaType2)) {
                            fArray2[1] = f5;
                            fArray3[1] = f6;
                        } else {
                            fArray2[1] = 1.0f - f5;
                            fArray3[1] = 1.0f - f6;
                        }
                    } else {
                        fArray2[1] = 1.0f;
                        fArray3[1] = 1.0f;
                    }
                    if (mediaType != null && f3 != 1.0f) {
                        if (mediaType4.equals(mediaType)) {
                            fArray2[2] = f3;
                            fArray3[2] = f4;
                        } else {
                            fArray2[2] = 1.0f - f3;
                            fArray3[2] = 1.0f - f4;
                        }
                    } else {
                        fArray2[2] = 1.0f;
                        fArray3[2] = 1.0f;
                    }
                } else {
                    fArray[0] = 0.1f;
                }
                float[] fArray4 = new float[3];
                float[] fArray5 = new float[3];
                if (mimeType2 != null && f5 != 1.0f) {
                    fArray4[1] = f5;
                    fArray5[1] = f6;
                    if (mediaType4 != null && f != 1.0f) {
                        if (mediaType2.equals(mediaType4)) {
                            fArray4[0] = f;
                            fArray5[0] = f2;
                        } else {
                            fArray4[0] = 1.0f - f;
                            fArray5[0] = 1.0f - f2;
                        }
                    } else {
                        fArray4[0] = 1.0f;
                        fArray5[0] = 1.0f;
                    }
                    if (mediaType != null && f3 != 1.0f) {
                        if (mediaType2.equals(mediaType)) {
                            fArray4[2] = f3;
                            fArray5[2] = f4;
                        } else {
                            fArray4[2] = 1.0f - f3;
                            fArray5[2] = 1.0f - f4;
                        }
                    } else {
                        fArray4[2] = 1.0f;
                        fArray5[2] = 1.0f;
                    }
                } else {
                    fArray[1] = 0.1f;
                }
                float[] fArray6 = new float[3];
                float[] fArray7 = new float[3];
                if (mediaType != null && f3 != 1.0f) {
                    fArray6[2] = f3;
                    fArray7[2] = f4;
                    if (mediaType4 != null && f != 1.0f) {
                        if (mediaType4.equals(mediaType)) {
                            fArray6[0] = f;
                            fArray7[0] = f2;
                        } else {
                            fArray6[0] = 1.0f - f;
                            fArray7[0] = 1.0f - f2;
                        }
                    } else {
                        fArray6[0] = 1.0f;
                        fArray7[0] = 1.0f;
                    }
                    if (mediaType2 != null && f5 != 1.0f) {
                        if (mediaType2.equals(mediaType)) {
                            fArray6[1] = f5;
                            fArray7[1] = f6;
                        } else {
                            fArray6[1] = 1.0f - f5;
                            fArray7[1] = 1.0f - f6;
                        }
                    } else {
                        fArray6[1] = 1.0f;
                        fArray7[1] = 1.0f;
                    }
                } else {
                    fArray[2] = 0.1f;
                }
                float f8 = this.priorMagicFileType;
                float f9 = 1.0f - this.priorMagicFileType;
                if (fArray[0] == 0.0f) {
                    for (n2 = 0; n2 < fArray2.length; ++n2) {
                        f8 *= fArray2[n2];
                        if (fArray2[n2] == 1.0f) continue;
                        f9 *= fArray3[n2];
                    }
                    f8 /= f8 + f9;
                    fArray[0] = f8;
                }
                if (f7 < fArray[0]) {
                    f7 = fArray[0];
                    mediaType3 = mediaType4;
                }
                f8 = this.priorMetaFileType;
                f9 = 1.0f - this.priorMetaFileType;
                if (fArray[1] == 0.0f) {
                    for (n2 = 0; n2 < fArray4.length; ++n2) {
                        f8 *= fArray4[n2];
                        if (fArray4[n2] == 1.0f) continue;
                        f9 *= fArray5[n2];
                    }
                    f8 /= f8 + f9;
                    fArray[1] = f8;
                }
                if (f7 < fArray[1]) {
                    f7 = fArray[1];
                    mediaType3 = mediaType2;
                }
                f8 = this.priorExtensionFileType;
                f9 = 1.0f - this.priorExtensionFileType;
                if (fArray[2] == 0.0f) {
                    for (n2 = 0; n2 < fArray6.length; ++n2) {
                        f8 *= fArray6[n2];
                        if (fArray6[n2] == 1.0f) continue;
                        f9 *= fArray7[n2];
                    }
                    f8 /= f8 + f9;
                    fArray[2] = f8;
                }
                if (!(f7 < fArray[2])) continue;
                f7 = fArray[2];
                mediaType3 = mediaType;
            }
        }
        return f7 < this.threshold ? this.rootMediaType : mediaType3;
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.mimeTypes.getMediaTypeRegistry();
    }

    public static class Builder {
        private float priorMagicFileType;
        private float priorExtensionFileType;
        private float priorMetaFileType;
        private float magic_trust;
        private float extension_trust;
        private float meta_trust;
        private float magic_neg;
        private float extension_neg;
        private float meta_neg;
        private float threshold;

        public synchronized Builder priorMagicFileType(float f) {
            this.priorMagicFileType = f;
            return this;
        }

        public synchronized Builder priorExtensionFileType(float f) {
            this.priorExtensionFileType = f;
            return this;
        }

        public synchronized Builder priorMetaFileType(float f) {
            this.priorMetaFileType = f;
            return this;
        }

        public synchronized Builder magic_trust(float f) {
            this.magic_trust = f;
            return this;
        }

        public synchronized Builder extension_trust(float f) {
            this.extension_trust = f;
            return this;
        }

        public synchronized Builder meta_trust(float f) {
            this.meta_trust = f;
            return this;
        }

        public synchronized Builder magic_neg(float f) {
            this.magic_neg = f;
            return this;
        }

        public synchronized Builder extension_neg(float f) {
            this.extension_neg = f;
            return this;
        }

        public synchronized Builder meta_neg(float f) {
            this.meta_neg = f;
            return this;
        }

        public synchronized Builder threshold(float f) {
            this.threshold = f;
            return this;
        }

        public ProbabilisticMimeDetectionSelector build2() {
            return new ProbabilisticMimeDetectionSelector(this);
        }
    }
}

