/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.sax.TaggedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CompositeParser
extends AbstractParser {
    private static final long serialVersionUID = 2192845797749627824L;
    private MediaTypeRegistry registry;
    private List<Parser> parsers;
    private Parser fallback = new EmptyParser();

    public CompositeParser(MediaTypeRegistry mediaTypeRegistry, List<Parser> list, Collection<Class<? extends Parser>> collection) {
        if (collection == null || collection.isEmpty()) {
            this.parsers = list;
        } else {
            this.parsers = new ArrayList<Parser>();
            for (Parser parser : list) {
                if (this.isExcluded(collection, parser.getClass())) continue;
                this.parsers.add(parser);
            }
        }
        this.registry = mediaTypeRegistry;
    }

    public CompositeParser(MediaTypeRegistry mediaTypeRegistry, List<Parser> list) {
        this(mediaTypeRegistry, list, null);
    }

    public CompositeParser(MediaTypeRegistry mediaTypeRegistry, Parser ... parserArray) {
        this(mediaTypeRegistry, Arrays.asList(parserArray));
    }

    public CompositeParser() {
        this(new MediaTypeRegistry(), new Parser[0]);
    }

    public Map<MediaType, Parser> getParsers(ParseContext parseContext) {
        HashMap<MediaType, Parser> hashMap = new HashMap<MediaType, Parser>();
        for (Parser parser : this.parsers) {
            for (MediaType mediaType : parser.getSupportedTypes(parseContext)) {
                hashMap.put(this.registry.normalize(mediaType), parser);
            }
        }
        return hashMap;
    }

    private boolean isExcluded(Collection<Class<? extends Parser>> collection, Class<? extends Parser> clazz) {
        return collection.contains(clazz) || this.assignableFrom(collection, clazz);
    }

    private boolean assignableFrom(Collection<Class<? extends Parser>> collection, Class<? extends Parser> clazz) {
        for (Class<? extends Parser> clazz2 : collection) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public Map<MediaType, List<Parser>> findDuplicateParsers(ParseContext parseContext) {
        HashMap<MediaType, Parser> hashMap = new HashMap<MediaType, Parser>();
        HashMap<MediaType, List<Parser>> hashMap2 = new HashMap<MediaType, List<Parser>>();
        for (Parser parser : this.parsers) {
            for (MediaType mediaType : parser.getSupportedTypes(parseContext)) {
                MediaType mediaType2 = this.registry.normalize(mediaType);
                if (hashMap.containsKey(mediaType2)) {
                    ArrayList<Parser> arrayList = (ArrayList<Parser>)hashMap2.get(mediaType2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Parser>();
                        arrayList.add((Parser)hashMap.get(mediaType2));
                        hashMap2.put(mediaType2, arrayList);
                    }
                    arrayList.add(parser);
                    continue;
                }
                hashMap.put(mediaType2, parser);
            }
        }
        return hashMap2;
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.registry;
    }

    public void setMediaTypeRegistry(MediaTypeRegistry mediaTypeRegistry) {
        this.registry = mediaTypeRegistry;
    }

    public List<Parser> getAllComponentParsers() {
        return Collections.unmodifiableList(this.parsers);
    }

    public Map<MediaType, Parser> getParsers() {
        return this.getParsers(new ParseContext());
    }

    public void setParsers(Map<MediaType, Parser> map) {
        this.parsers = new ArrayList<Parser>(map.size());
        for (Map.Entry<MediaType, Parser> entry : map.entrySet()) {
            this.parsers.add(ParserDecorator.withTypes(entry.getValue(), Collections.singleton(entry.getKey())));
        }
    }

    public Parser getFallback() {
        return this.fallback;
    }

    public void setFallback(Parser parser) {
        this.fallback = parser;
    }

    protected Parser getParser(Metadata metadata) {
        return this.getParser(metadata, new ParseContext());
    }

    protected Parser getParser(Metadata metadata, ParseContext parseContext) {
        Map<MediaType, Parser> map = this.getParsers(parseContext);
        MediaType mediaType = MediaType.parse(metadata.get("Content-Type"));
        if (mediaType != null) {
            mediaType = this.registry.normalize(mediaType);
        }
        while (mediaType != null) {
            Parser parser = map.get(mediaType);
            if (parser != null) {
                return parser;
            }
            mediaType = this.registry.getSupertype(mediaType);
        }
        return this.fallback;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.getParsers(parseContext).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        Parser parser = this.getParser(metadata, parseContext);
        TemporaryResources temporaryResources = new TemporaryResources();
        try {
            TaggedContentHandler taggedContentHandler;
            TikaInputStream tikaInputStream = TikaInputStream.get(inputStream, temporaryResources);
            TaggedContentHandler taggedContentHandler2 = taggedContentHandler = contentHandler != null ? new TaggedContentHandler(contentHandler) : null;
            if (parser instanceof ParserDecorator) {
                metadata.add("X-Parsed-By", ((ParserDecorator)parser).getWrappedParser().getClass().getName());
            } else {
                metadata.add("X-Parsed-By", parser.getClass().getName());
            }
            try {
                parser.parse(tikaInputStream, taggedContentHandler, metadata, parseContext);
            }
            catch (RuntimeException runtimeException) {
                throw new TikaException("Unexpected RuntimeException from " + parser, runtimeException);
            }
            catch (IOException iOException) {
                tikaInputStream.throwIfCauseOf(iOException);
                throw new TikaException("TIKA-198: Illegal IOException from " + parser, iOException);
            }
            catch (SAXException sAXException) {
                if (taggedContentHandler != null) {
                    taggedContentHandler.throwIfCauseOf(sAXException);
                }
                throw new TikaException("TIKA-237: Illegal SAXException from " + parser, sAXException);
            }
        }
        finally {
            temporaryResources.dispose();
        }
    }
}

