/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class CryptoParser
extends DelegatingParser {
    private static final long serialVersionUID = -3507995752666557731L;
    private final String transformation;
    private final Provider provider;
    private final Set<MediaType> types;

    public CryptoParser(String string, Provider provider, Set<MediaType> set) {
        this.transformation = string;
        this.provider = provider;
        this.types = set;
    }

    public CryptoParser(String string, Set<MediaType> set) {
        this(string, null, set);
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.types;
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        try {
            Cipher cipher = this.provider != null ? Cipher.getInstance(this.transformation, this.provider) : Cipher.getInstance(this.transformation);
            Key key = parseContext.get(Key.class);
            if (key == null) {
                throw new EncryptedDocumentException("No decryption key provided");
            }
            AlgorithmParameters algorithmParameters = parseContext.get(AlgorithmParameters.class);
            SecureRandom secureRandom = parseContext.get(SecureRandom.class);
            if (algorithmParameters != null && secureRandom != null) {
                cipher.init(2, key, algorithmParameters, secureRandom);
            } else if (algorithmParameters != null) {
                cipher.init(2, key, algorithmParameters);
            } else if (secureRandom != null) {
                cipher.init(2, key, secureRandom);
            } else {
                cipher.init(2, key);
            }
            super.parse(new CipherInputStream(inputStream, cipher), contentHandler, metadata, parseContext);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TikaException("Unable to decrypt document stream", generalSecurityException);
        }
    }
}

