/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.utils.ServiceLoaderUtils;

public class DefaultParser
extends CompositeParser {
    private static final long serialVersionUID = 3612324825403757520L;
    private final transient ServiceLoader loader;

    private static List<Parser> getDefaultParsers(ServiceLoader serviceLoader) {
        List<Parser> list = serviceLoader.loadStaticServiceProviders(Parser.class);
        ServiceLoaderUtils.sortLoadedClasses(list);
        return list;
    }

    public DefaultParser(MediaTypeRegistry mediaTypeRegistry, ServiceLoader serviceLoader, Collection<Class<? extends Parser>> collection) {
        super(mediaTypeRegistry, DefaultParser.getDefaultParsers(serviceLoader), collection);
        this.loader = serviceLoader;
    }

    public DefaultParser(MediaTypeRegistry mediaTypeRegistry, ServiceLoader serviceLoader) {
        this(mediaTypeRegistry, serviceLoader, null);
    }

    public DefaultParser(MediaTypeRegistry mediaTypeRegistry, ClassLoader classLoader) {
        this(mediaTypeRegistry, new ServiceLoader(classLoader));
    }

    public DefaultParser(ClassLoader classLoader) {
        this(MediaTypeRegistry.getDefaultRegistry(), new ServiceLoader(classLoader));
    }

    public DefaultParser(MediaTypeRegistry mediaTypeRegistry) {
        this(mediaTypeRegistry, new ServiceLoader());
    }

    public DefaultParser() {
        this(MediaTypeRegistry.getDefaultRegistry());
    }

    @Override
    public Map<MediaType, Parser> getParsers(ParseContext parseContext) {
        Map<MediaType, Parser> map = super.getParsers(parseContext);
        if (this.loader != null) {
            MediaTypeRegistry mediaTypeRegistry = this.getMediaTypeRegistry();
            List<Parser> list = this.loader.loadDynamicServiceProviders(Parser.class);
            Collections.reverse(list);
            for (Parser parser : list) {
                for (MediaType mediaType : parser.getSupportedTypes(parseContext)) {
                    map.put(mediaTypeRegistry.normalize(mediaType), parser);
                }
            }
        }
        return map;
    }

    @Override
    public List<Parser> getAllComponentParsers() {
        List<Parser> list = super.getAllComponentParsers();
        if (this.loader != null) {
            list = new ArrayList<Parser>(list);
            list.addAll(this.loader.loadDynamicServiceProviders(Parser.class));
        }
        return list;
    }
}

