/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ParserDecorator
extends AbstractParser {
    private static final long serialVersionUID = -3861669115439125268L;
    private final Parser parser;

    public static final Parser withTypes(Parser parser, final Set<MediaType> set) {
        return new ParserDecorator(parser){
            private static final long serialVersionUID = -7345051519565330731L;

            @Override
            public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
                return set;
            }

            @Override
            public String getDecorationName() {
                return "With Types";
            }
        };
    }

    public static final Parser withoutTypes(Parser parser, final Set<MediaType> set) {
        return new ParserDecorator(parser){
            private static final long serialVersionUID = 7979614774021768609L;

            @Override
            public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
                HashSet<MediaType> hashSet = new HashSet<MediaType>(super.getSupportedTypes(parseContext));
                hashSet.removeAll(set);
                return hashSet;
            }

            @Override
            public String getDecorationName() {
                return "Without Types";
            }
        };
    }

    public static final Parser withFallbacks(final Collection<? extends Parser> collection, final Set<MediaType> set) {
        Parser parser = EmptyParser.INSTANCE;
        if (!collection.isEmpty()) {
            parser = collection.iterator().next();
        }
        return new ParserDecorator(parser){
            private static final long serialVersionUID = 1625187131782069683L;

            @Override
            public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
                return set;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
                TemporaryResources temporaryResources = TikaInputStream.isTikaInputStream(inputStream) ? null : new TemporaryResources();
                try {
                    TikaInputStream tikaInputStream = TikaInputStream.get(inputStream, temporaryResources);
                    tikaInputStream.getFile();
                    for (Parser parser : collection) {
                        tikaInputStream.mark(-1);
                        try {
                            parser.parse(tikaInputStream, contentHandler, metadata, parseContext);
                            return;
                        }
                        catch (Exception exception) {
                            try {
                                tikaInputStream.reset();
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                                return;
                            }
                        }
                    }
                }
                finally {
                    if (temporaryResources != null) {
                        temporaryResources.dispose();
                    }
                }
            }

            @Override
            public String getDecorationName() {
                return "With Fallback";
            }
        };
    }

    public ParserDecorator(Parser parser) {
        this.parser = parser;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.parser.getSupportedTypes(parseContext);
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        this.parser.parse(inputStream, contentHandler, metadata, parseContext);
    }

    public String getDecorationName() {
        return null;
    }

    public Parser getWrappedParser() {
        return this.parser;
    }
}

