/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmItsfHeader;
import org.apache.tika.parser.chm.accessor.ChmItspHeader;
import org.apache.tika.parser.chm.accessor.ChmPmglHeader;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmDirectoryListingSet {
    private List<DirectoryListingEntry> dlel;
    private byte[] data;
    private int placeHolder = -1;
    private long dataOffset = -1L;
    private int controlDataIndex = -1;
    private int resetTableIndex = -1;
    private boolean isNotControlDataFound = true;
    private boolean isNotResetTableFound = true;
    private ChmPmglHeader PMGLheader;

    public ChmDirectoryListingSet(byte[] byArray, ChmItsfHeader chmItsfHeader, ChmItspHeader chmItspHeader) throws TikaException {
        this.setDirectoryListingEntryList(new ArrayList<DirectoryListingEntry>());
        ChmCommons.assertByteArrayNotNull(byArray);
        this.setData(byArray);
        this.enumerateChmDirectoryListingList(chmItsfHeader, chmItspHeader);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("list:=" + this.getDirectoryListingEntryList().toString() + System.getProperty("line.separator"));
        stringBuilder.append("number of list items:=" + this.getDirectoryListingEntryList().size());
        return stringBuilder.toString();
    }

    public int getControlDataIndex() {
        return this.controlDataIndex;
    }

    protected void setControlDataIndex(int n) {
        this.controlDataIndex = n;
    }

    public int getResetTableIndex() {
        return this.resetTableIndex;
    }

    protected void setResetTableIndex(int n) {
        this.resetTableIndex = n;
    }

    private void setPlaceHolder(int n) {
        this.placeHolder = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enumerateChmDirectoryListingList(ChmItsfHeader chmItsfHeader, ChmItspHeader chmItspHeader) {
        try {
            int n = chmItspHeader.getIndex_head();
            int n2 = chmItspHeader.getUnknown_0024();
            int n3 = (int)(chmItsfHeader.getDirOffset() + (long)chmItspHeader.getHeader_len());
            this.setDataOffset(chmItsfHeader.getDataOffset());
            byte[] byArray = null;
            int n4 = n;
            while (n4 >= 0) {
                byArray = new byte[(int)chmItspHeader.getBlock_len()];
                int n5 = n4 * (int)chmItspHeader.getBlock_len() + n3;
                byArray = ChmCommons.copyOfRange(this.getData(), n5, n5 + (int)chmItspHeader.getBlock_len());
                this.PMGLheader = new ChmPmglHeader();
                this.PMGLheader.parse(byArray, this.PMGLheader);
                this.enumerateOneSegment(byArray);
                n4 = this.PMGLheader.getBlockNext();
                byArray = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setData(null);
        }
    }

    private void checkControlData(DirectoryListingEntry directoryListingEntry) {
        if (this.isNotControlDataFound && directoryListingEntry.getName().contains("ControlData")) {
            this.setControlDataIndex(this.getDirectoryListingEntryList().size());
            this.isNotControlDataFound = false;
        }
    }

    private void checkResetTable(DirectoryListingEntry directoryListingEntry) {
        if (this.isNotResetTableFound && directoryListingEntry.getName().contains("ResetTable")) {
            this.setResetTableIndex(this.getDirectoryListingEntryList().size());
            this.isNotResetTableFound = false;
        }
    }

    public static final boolean startsWith(byte[] byArray, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (byArray[i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void enumerateOneSegment(byte[] byArray) throws ChmParsingException {
        if (byArray != null) {
            if (ChmDirectoryListingSet.startsWith(byArray, "PMGI")) {
                int n = 8;
                return;
            }
            if (!ChmDirectoryListingSet.startsWith(byArray, "PMGL")) {
                throw new ChmParsingException("Bad dir entry block.");
            }
            int n = 20;
            this.placeHolder = n;
            while (this.placeHolder > 0 && (long)this.placeHolder < (long)byArray.length - this.PMGLheader.getFreeSpace()) {
                byte by;
                int n2 = 0;
                while ((by = byArray[this.placeHolder++]) >= 128) {
                    n2 <<= 7;
                    n2 += by & 0x7F;
                }
                if ((n2 = (n2 << 7) + by & 0x7F) > byArray.length) {
                    throw new ChmParsingException("Bad data of a string length.");
                }
                DirectoryListingEntry directoryListingEntry = new DirectoryListingEntry();
                directoryListingEntry.setNameLength(n2);
                directoryListingEntry.setName(new String(ChmCommons.copyOfRange(byArray, this.placeHolder, this.placeHolder + directoryListingEntry.getNameLength()), StandardCharsets.UTF_8));
                this.checkControlData(directoryListingEntry);
                this.checkResetTable(directoryListingEntry);
                this.setPlaceHolder(this.placeHolder + directoryListingEntry.getNameLength());
                if (this.placeHolder < byArray.length && byArray[this.placeHolder] == 0) {
                    directoryListingEntry.setEntryType(ChmCommons.EntryType.UNCOMPRESSED);
                } else {
                    directoryListingEntry.setEntryType(ChmCommons.EntryType.COMPRESSED);
                }
                this.setPlaceHolder(this.placeHolder + 1);
                directoryListingEntry.setOffset(this.getEncint(byArray));
                directoryListingEntry.setLength(this.getEncint(byArray));
                this.getDirectoryListingEntryList().add(directoryListingEntry);
            }
        }
    }

    private int getEncint(byte[] byArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        byte[] byArray2 = new byte[1];
        if (this.placeHolder < byArray.length) {
            byte by;
            while ((by = byArray[this.placeHolder]) < 0) {
                byArray2[0] = (byte)(by & 0x7F);
                bigInteger = bigInteger.shiftLeft(7).add(new BigInteger(byArray2));
                this.setPlaceHolder(this.placeHolder + 1);
            }
            byArray2[0] = (byte)(by & 0x7F);
            bigInteger = bigInteger.shiftLeft(7).add(new BigInteger(byArray2));
            this.setPlaceHolder(this.placeHolder + 1);
        }
        return bigInteger.intValue();
    }

    public void setDirectoryListingEntryList(List<DirectoryListingEntry> list) {
        this.dlel = list;
    }

    public List<DirectoryListingEntry> getDirectoryListingEntryList() {
        return this.dlel;
    }

    private void setData(byte[] byArray) {
        this.data = byArray;
    }

    private byte[] getData() {
        return this.data;
    }

    private void setDataOffset(long l) {
        this.dataOffset = l;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }
}

