/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmItspHeader
implements ChmAccessor<ChmItspHeader> {
    private static final long serialVersionUID = 1962394421998181341L;
    private byte[] signature;
    private int version;
    private int header_len;
    private int unknown_000c;
    private long block_len;
    private int blockidx_intvl;
    private int index_depth;
    private int index_root;
    private int index_head;
    private int unknown_0024;
    private long num_blocks;
    private int unknown_002c;
    private long lang_id;
    private byte[] system_uuid = new byte[16];
    private byte[] unknown_0044 = new byte[16];
    private int dataRemained;
    private int currentPlace = 0;

    public ChmItspHeader() {
        this.signature = "ITSP".getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ signature:=" + new String(this.getSignature(), StandardCharsets.UTF_8) + System.getProperty("line.separator"));
        stringBuilder.append("version:=\t" + this.getVersion() + System.getProperty("line.separator"));
        stringBuilder.append("header_len:=\t" + this.getHeader_len() + System.getProperty("line.separator"));
        stringBuilder.append("unknown_00c:=\t" + this.getUnknown_000c() + System.getProperty("line.separator"));
        stringBuilder.append("block_len:=\t" + this.getBlock_len() + " [directory chunk size]" + System.getProperty("line.separator"));
        stringBuilder.append("blockidx_intvl:=" + this.getBlockidx_intvl() + ", density of quickref section, usually 2" + System.getProperty("line.separator"));
        stringBuilder.append("index_depth:=\t" + this.getIndex_depth() + ", depth of the index tree - 1 there is no index, 2 if there is one level of PMGI chunk" + System.getProperty("line.separator"));
        stringBuilder.append("index_root:=\t" + this.getIndex_root() + ", chunk number of root index chunk, -1 if there is none" + System.getProperty("line.separator"));
        stringBuilder.append("index_head:=\t" + this.getIndex_head() + ", chunk number of first PMGL (listing) chunk" + System.getProperty("line.separator"));
        stringBuilder.append("unknown_0024:=\t" + this.getUnknown_0024() + ", chunk number of last PMGL (listing) chunk" + System.getProperty("line.separator"));
        stringBuilder.append("num_blocks:=\t" + this.getNum_blocks() + ", -1 (unknown)" + System.getProperty("line.separator"));
        stringBuilder.append("unknown_002c:=\t" + this.getUnknown_002c() + ", number of directory chunks (total)" + System.getProperty("line.separator"));
        stringBuilder.append("lang_id:=\t" + this.getLang_id() + " - " + ChmCommons.getLanguage(this.getLang_id()) + System.getProperty("line.separator"));
        stringBuilder.append("system_uuid:=" + this.getSystem_uuid() + System.getProperty("line.separator"));
        stringBuilder.append("unknown_0044:=" + this.getUnknown_0044() + " ]");
        return stringBuilder.toString();
    }

    private void unmarshalCharArray(byte[] byArray, ChmItspHeader chmItspHeader, int n) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        ChmAssert.assertChmAccessorNotNull(chmItspHeader);
        this.setDataRemained(byArray.length);
        System.arraycopy(byArray, 0, chmItspHeader.signature, 0, n);
        this.setCurrentPlace(this.getCurrentPlace() + n);
        this.setDataRemained(this.getDataRemained() - n);
    }

    private int unmarshalInt32(byte[] byArray, int n, int n2) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (4 > this.getDataRemained()) {
            throw new TikaException("4 > dataLenght");
        }
        n2 = byArray[this.getCurrentPlace()] & 0xFF | (byArray[this.getCurrentPlace() + 1] & 0xFF) << 8 | (byArray[this.getCurrentPlace() + 2] & 0xFF) << 16 | (byArray[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        this.setDataRemained(this.getDataRemained() - 4);
        return n2;
    }

    private long unmarshalUInt32(byte[] byArray, int n, long l) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (4 > n) {
            throw new TikaException("4 > dataLenght");
        }
        l = byArray[this.getCurrentPlace()] & 0xFF | (byArray[this.getCurrentPlace() + 1] & 0xFF) << 8 | (byArray[this.getCurrentPlace() + 2] & 0xFF) << 16 | (byArray[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return l;
    }

    private byte[] unmarshalUuid(byte[] byArray, int n, byte[] byArray2, int n2) {
        System.arraycopy(byArray, this.getCurrentPlace(), byArray2, 0, n2);
        this.setCurrentPlace(this.getCurrentPlace() + n2);
        this.setDataRemained(this.getDataRemained() - n2);
        return byArray2;
    }

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int n) {
        this.dataRemained = n;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int n) {
        this.currentPlace = n;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int n) {
        this.version = n;
    }

    public int getHeader_len() {
        return this.header_len;
    }

    protected void setHeader_len(int n) {
        this.header_len = n;
    }

    public int getUnknown_000c() {
        return this.unknown_000c;
    }

    protected void setUnknown_000c(int n) {
        this.unknown_000c = n;
    }

    public long getBlock_len() {
        return this.block_len;
    }

    protected void setBlock_len(long l) {
        this.block_len = l;
    }

    public int getBlockidx_intvl() {
        return this.blockidx_intvl;
    }

    protected void setBlockidx_intvl(int n) {
        this.blockidx_intvl = n;
    }

    public int getIndex_depth() {
        return this.index_depth;
    }

    protected void setIndex_depth(int n) {
        this.index_depth = n;
    }

    public int getIndex_root() {
        return this.index_root;
    }

    protected void setIndex_root(int n) {
        this.index_root = n;
    }

    public int getIndex_head() {
        return this.index_head;
    }

    protected void setIndex_head(int n) {
        this.index_head = n;
    }

    public int getUnknown_0024() {
        return this.unknown_0024;
    }

    protected void setUnknown_0024(int n) {
        this.unknown_0024 = n;
    }

    public long getNum_blocks() {
        return this.num_blocks;
    }

    protected void setNum_blocks(long l) {
        this.num_blocks = l;
    }

    public int getUnknown_002c() {
        return this.unknown_002c;
    }

    protected void setUnknown_002c(int n) {
        this.unknown_002c = n;
    }

    public long getLang_id() {
        return this.lang_id;
    }

    protected void setLang_id(long l) {
        this.lang_id = l;
    }

    public byte[] getSystem_uuid() {
        return this.system_uuid;
    }

    protected void setSystem_uuid(byte[] byArray) {
        this.system_uuid = byArray;
    }

    public byte[] getUnknown_0044() {
        return this.unknown_0044;
    }

    protected void setUnknown_0044(byte[] byArray) {
        this.unknown_0044 = byArray;
    }

    @Override
    public void parse(byte[] byArray, ChmItspHeader chmItspHeader) throws TikaException {
        if (byArray.length != 84) {
            throw new ChmParsingException("we only know how to deal with the 0x58 and 0x60 byte structures");
        }
        chmItspHeader.unmarshalCharArray(byArray, chmItspHeader, 4);
        chmItspHeader.setVersion(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getVersion()));
        chmItspHeader.setHeader_len(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getHeader_len()));
        chmItspHeader.setUnknown_000c(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_000c()));
        chmItspHeader.setBlock_len(chmItspHeader.unmarshalUInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getBlock_len()));
        chmItspHeader.setBlockidx_intvl(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getBlockidx_intvl()));
        chmItspHeader.setIndex_depth(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getIndex_depth()));
        chmItspHeader.setIndex_root(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getIndex_root()));
        chmItspHeader.setIndex_head(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getIndex_head()));
        chmItspHeader.setUnknown_0024(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_0024()));
        chmItspHeader.setNum_blocks(chmItspHeader.unmarshalUInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getNum_blocks()));
        chmItspHeader.setUnknown_002c(chmItspHeader.unmarshalInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_002c()));
        chmItspHeader.setLang_id(chmItspHeader.unmarshalUInt32(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getLang_id()));
        chmItspHeader.setSystem_uuid(chmItspHeader.unmarshalUuid(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getSystem_uuid(), 16));
        chmItspHeader.setUnknown_0044(chmItspHeader.unmarshalUuid(byArray, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_0044(), 16));
        if (!new String(chmItspHeader.getSignature(), StandardCharsets.UTF_8).equals("ITSP")) {
            throw new ChmParsingException("seems not valid signature");
        }
        if (chmItspHeader.getVersion() != 1) {
            throw new ChmParsingException("!=ChmConstants.CHM_VER_1");
        }
        if (chmItspHeader.getHeader_len() != 84) {
            throw new ChmParsingException("!= ChmConstants.CHM_ITSP_V1_LEN");
        }
    }
}

