/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmPmgiHeader
implements ChmAccessor<ChmPmgiHeader> {
    private static final long serialVersionUID = -2092282339894303701L;
    private byte[] signature = "PMGI".getBytes(StandardCharsets.UTF_8);
    private long free_space;
    private int dataRemained;
    private int currentPlace = 0;

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int n) {
        this.dataRemained = n;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int n) {
        this.currentPlace = n;
    }

    private void unmarshalCharArray(byte[] byArray, ChmPmgiHeader chmPmgiHeader, int n) throws ChmParsingException {
        int n2 = -1;
        ChmAssert.assertByteArrayNotNull(byArray);
        ChmAssert.assertChmAccessorNotNull(chmPmgiHeader);
        ChmAssert.assertPositiveInt(n);
        this.setDataRemained(byArray.length);
        n2 = ChmCommons.indexOf(byArray, "PMGI".getBytes(StandardCharsets.UTF_8));
        if (n2 >= 0) {
            System.arraycopy(byArray, n2, chmPmgiHeader.getSignature(), 0, n);
        }
        this.setCurrentPlace(this.getCurrentPlace() + n);
        this.setDataRemained(this.getDataRemained() - n);
    }

    private long unmarshalUInt32(byte[] byArray, long l) throws ChmParsingException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (4 > this.getDataRemained()) {
            throw new ChmParsingException("4 > dataLenght");
        }
        l = byArray[this.getCurrentPlace()] & 0xFF | (byArray[this.getCurrentPlace() + 1] & 0xFF) << 8 | (byArray[this.getCurrentPlace() + 2] & 0xFF) << 16 | (byArray[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return l;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public long getFreeSpace() {
        return this.free_space;
    }

    protected void setFreeSpace(long l) {
        this.free_space = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("signature:=" + new String(this.getSignature(), StandardCharsets.UTF_8) + ", ");
        stringBuilder.append("free space:=" + this.getFreeSpace() + System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    @Override
    public void parse(byte[] byArray, ChmPmgiHeader chmPmgiHeader) throws TikaException {
        if (byArray.length < 8) {
            throw new TikaException("we only know how to deal with a 0x8 byte structures");
        }
        chmPmgiHeader.unmarshalCharArray(byArray, chmPmgiHeader, 4);
        chmPmgiHeader.setFreeSpace(chmPmgiHeader.unmarshalUInt32(byArray, chmPmgiHeader.getFreeSpace()));
        if (!Arrays.equals(chmPmgiHeader.getSignature(), "PMGI".getBytes(StandardCharsets.UTF_8))) {
            throw new TikaException("it does not seem to be valid a PMGI signature, check ChmItsp index_root if it was -1, means no PMGI, use PMGL insted");
        }
    }
}

