/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.accessor;

import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmAccessor;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmPmglHeader
implements ChmAccessor<ChmPmglHeader> {
    private static final long serialVersionUID = -6139486487475923593L;
    private byte[] signature = "PMGL".getBytes(StandardCharsets.UTF_8);
    private long free_space;
    private long unknown_0008;
    private int block_prev;
    private int block_next;
    private int dataRemained;
    private int currentPlace = 0;

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int n) {
        this.dataRemained = n;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int n) {
        this.currentPlace = n;
    }

    public long getFreeSpace() {
        return this.free_space;
    }

    public void setFreeSpace(long l) throws TikaException {
        if (l < 0L) {
            throw new TikaException("Bad PMGLheader.FreeSpace=" + l);
        }
        this.free_space = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("signatute:=" + new String(this.getSignature(), StandardCharsets.UTF_8) + ", ");
        stringBuilder.append("free space:=" + this.getFreeSpace() + ", ");
        stringBuilder.append("unknown0008:=" + this.getUnknown0008() + ", ");
        stringBuilder.append("prev block:=" + this.getBlockPrev() + ", ");
        stringBuilder.append("next block:=" + this.getBlockNext() + System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    protected void unmarshalCharArray(byte[] byArray, ChmPmglHeader chmPmglHeader, int n) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        this.setDataRemained(byArray.length);
        System.arraycopy(byArray, 0, chmPmglHeader.signature, 0, n);
        this.setCurrentPlace(this.getCurrentPlace() + n);
        this.setDataRemained(this.getDataRemained() - n);
    }

    private int unmarshalInt32(byte[] byArray) throws TikaException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (4 > this.getDataRemained()) {
            throw new TikaException("4 > dataLenght");
        }
        int n = byArray[this.getCurrentPlace()] & 0xFF | (byArray[this.getCurrentPlace() + 1] & 0xFF) << 8 | (byArray[this.getCurrentPlace() + 2] & 0xFF) << 16 | (byArray[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        this.setDataRemained(this.getDataRemained() - 4);
        return n;
    }

    private long unmarshalUInt32(byte[] byArray) throws ChmParsingException {
        ChmAssert.assertByteArrayNotNull(byArray);
        if (4 > this.getDataRemained()) {
            throw new ChmParsingException("4 > dataLenght");
        }
        long l = byArray[this.getCurrentPlace()] & 0xFF | (byArray[this.getCurrentPlace() + 1] & 0xFF) << 8 | (byArray[this.getCurrentPlace() + 2] & 0xFF) << 16 | (byArray[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return l;
    }

    @Override
    public void parse(byte[] byArray, ChmPmglHeader chmPmglHeader) throws TikaException {
        if (byArray.length < 20) {
            throw new TikaException(ChmPmglHeader.class.getName() + " we only know how to deal with a 0x14 byte structures");
        }
        chmPmglHeader.unmarshalCharArray(byArray, chmPmglHeader, 4);
        chmPmglHeader.setFreeSpace(chmPmglHeader.unmarshalUInt32(byArray));
        chmPmglHeader.setUnknown0008(chmPmglHeader.unmarshalUInt32(byArray));
        chmPmglHeader.setBlockPrev(chmPmglHeader.unmarshalInt32(byArray));
        chmPmglHeader.setBlockNext(chmPmglHeader.unmarshalInt32(byArray));
        if (!new String(chmPmglHeader.getSignature(), StandardCharsets.UTF_8).equals("PMGL")) {
            throw new ChmParsingException(ChmPmglHeader.class.getName() + " pmgl != pmgl.signature");
        }
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public long getUnknown0008() {
        return this.unknown_0008;
    }

    protected void setUnknown0008(long l) {
        this.unknown_0008 = l;
    }

    public int getBlockPrev() {
        return this.block_prev;
    }

    protected void setBlockPrev(int n) {
        this.block_prev = n;
    }

    public int getBlockNext() {
        return this.block_next;
    }

    protected void setBlockNext(int n) {
        this.block_next = n;
    }
}

