/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmDirectoryListingSet;
import org.apache.tika.parser.chm.accessor.ChmItsfHeader;
import org.apache.tika.parser.chm.accessor.ChmItspHeader;
import org.apache.tika.parser.chm.accessor.ChmLzxcControlData;
import org.apache.tika.parser.chm.accessor.ChmLzxcResetTable;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.lzx.ChmBlockInfo;
import org.apache.tika.parser.chm.lzx.ChmLzxBlock;

public class ChmExtractor {
    private List<ChmLzxBlock> lzxBlocksCache = null;
    private ChmDirectoryListingSet chmDirList = null;
    private ChmItsfHeader chmItsfHeader = null;
    private ChmItspHeader chmItspHeader = null;
    private ChmLzxcResetTable chmLzxcResetTable = null;
    private ChmLzxcControlData chmLzxcControlData = null;
    private byte[] data = null;
    private int indexOfContent;
    private long lzxBlockOffset;
    private long lzxBlockLength;

    private ChmLzxcControlData getChmLzxcControlData() {
        return this.chmLzxcControlData;
    }

    private void setChmLzxcControlData(ChmLzxcControlData chmLzxcControlData) {
        this.chmLzxcControlData = chmLzxcControlData;
    }

    private ChmItspHeader getChmItspHeader() {
        return this.chmItspHeader;
    }

    private void setChmItspHeader(ChmItspHeader chmItspHeader) {
        this.chmItspHeader = chmItspHeader;
    }

    private ChmLzxcResetTable getChmLzxcResetTable() {
        return this.chmLzxcResetTable;
    }

    private void setChmLzxcResetTable(ChmLzxcResetTable chmLzxcResetTable) {
        this.chmLzxcResetTable = chmLzxcResetTable;
    }

    private long getLzxBlockLength() {
        return this.lzxBlockLength;
    }

    private void setLzxBlockLength(long l) {
        this.lzxBlockLength = l;
    }

    private long getLzxBlockOffset() {
        return this.lzxBlockOffset;
    }

    private void setLzxBlockOffset(long l) {
        this.lzxBlockOffset = l;
    }

    private int getIndexOfContent() {
        return this.indexOfContent;
    }

    private void setIndexOfContent(int n) {
        this.indexOfContent = n;
    }

    private byte[] getData() {
        return this.data;
    }

    private void setData(byte[] byArray) {
        this.data = byArray;
    }

    public ChmExtractor(InputStream inputStream) throws TikaException, IOException {
        ChmAssert.assertInputStreamNotNull(inputStream);
        try {
            this.setData(IOUtils.toByteArray((InputStream)inputStream));
            this.setChmItsfHeader(new ChmItsfHeader());
            this.getChmItsfHeader().parse(ChmCommons.copyOfRange(this.getData(), 0, 95), this.getChmItsfHeader());
            this.setChmItspHeader(new ChmItspHeader());
            this.getChmItspHeader().parse(ChmCommons.copyOfRange(this.getData(), (int)this.getChmItsfHeader().getDirOffset(), (int)this.getChmItsfHeader().getDirOffset() + 84), this.getChmItspHeader());
            this.setChmDirList(new ChmDirectoryListingSet(this.getData(), this.getChmItsfHeader(), this.getChmItspHeader()));
            int n = this.getChmDirList().getControlDataIndex();
            int n2 = ChmCommons.indexOfResetTableBlock(this.getData(), "LZXC".getBytes(StandardCharsets.UTF_8));
            byte[] byArray = null;
            if (n2 > 0) {
                byArray = ChmCommons.copyOfRange(this.getData(), n2, n2 + this.getChmDirList().getDirectoryListingEntryList().get(n).getLength());
            }
            this.setChmLzxcControlData(new ChmLzxcControlData());
            this.getChmLzxcControlData().parse(byArray, this.getChmLzxcControlData());
            int n3 = this.getChmDirList().getResetTableIndex();
            this.setChmLzxcResetTable(new ChmLzxcResetTable());
            int n4 = (int)this.getChmDirList().getDataOffset() + this.getChmDirList().getDirectoryListingEntryList().get(n3).getOffset();
            ChmAssert.assertCopyingDataIndex(n4, this.getData().length);
            byArray = ChmCommons.copyOfRange(this.getData(), n4, n4 + this.getChmDirList().getDirectoryListingEntryList().get(n3).getLength());
            this.getChmLzxcResetTable().parse(byArray, this.getChmLzxcResetTable());
            this.setIndexOfContent(ChmCommons.indexOf(this.getChmDirList().getDirectoryListingEntryList(), "Content"));
            this.setLzxBlockOffset((long)this.getChmDirList().getDirectoryListingEntryList().get(this.getIndexOfContent()).getOffset() + this.getChmItsfHeader().getDataOffset());
            this.setLzxBlockLength(this.getChmDirList().getDirectoryListingEntryList().get(this.getIndexOfContent()).getLength());
            this.setLzxBlocksCache(new ArrayList<ChmLzxBlock>());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public List<String> enumerateChm() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DirectoryListingEntry directoryListingEntry : this.getChmDirList().getDirectoryListingEntryList()) {
            arrayList.add(directoryListingEntry.getName());
        }
        return arrayList;
    }

    public byte[] extractChmEntry(DirectoryListingEntry directoryListingEntry) throws TikaException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ChmLzxBlock chmLzxBlock = null;
        try {
            if (directoryListingEntry.getEntryType() == ChmCommons.EntryType.UNCOMPRESSED && directoryListingEntry.getLength() > 0 && !ChmCommons.hasSkip(directoryListingEntry)) {
                int n = (int)(this.getChmItsfHeader().getDataOffset() + (long)directoryListingEntry.getOffset());
                byteArrayOutputStream.write(ChmCommons.copyOfRange(this.getData(), n, n + directoryListingEntry.getLength()));
            } else if (directoryListingEntry.getEntryType() == ChmCommons.EntryType.COMPRESSED && !ChmCommons.hasSkip(directoryListingEntry)) {
                ChmBlockInfo chmBlockInfo = ChmBlockInfo.getChmBlockInfoInstance(directoryListingEntry, (int)this.getChmLzxcResetTable().getBlockLen(), this.getChmLzxcControlData());
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                if (this.getLzxBlockLength() < Integer.MAX_VALUE && this.getLzxBlockOffset() < Integer.MAX_VALUE) {
                    n2 = -1;
                    if (!this.getLzxBlocksCache().isEmpty()) {
                        for (n = 0; n < this.getLzxBlocksCache().size(); ++n) {
                            int n4 = this.getLzxBlocksCache().get(n).getBlockNumber();
                            for (int i = chmBlockInfo.getIniBlock(); i <= chmBlockInfo.getStartBlock(); ++i) {
                                if (n4 != i || i <= n2) continue;
                                n2 = i;
                                n3 = n;
                            }
                            if (n2 == chmBlockInfo.getStartBlock()) break;
                        }
                    }
                    if (n2 < 0) {
                        n2 = chmBlockInfo.getIniBlock();
                        byte[] byArray = ChmCommons.getChmBlockSegment(this.getData(), this.getChmLzxcResetTable(), n2, (int)this.getLzxBlockOffset(), (int)this.getLzxBlockLength());
                        chmLzxBlock = new ChmLzxBlock(n2, byArray, this.getChmLzxcResetTable().getBlockLen(), null);
                        this.getLzxBlocksCache().add(chmLzxBlock);
                    } else {
                        chmLzxBlock = this.getLzxBlocksCache().get(n3);
                    }
                    n = n2;
                    while (n <= chmBlockInfo.getEndBlock()) {
                        if (n == chmBlockInfo.getStartBlock() && n == chmBlockInfo.getEndBlock()) {
                            byteArrayOutputStream.write(chmLzxBlock.getContent(chmBlockInfo.getStartOffset(), chmBlockInfo.getEndOffset()));
                            break;
                        }
                        if (n == chmBlockInfo.getStartBlock()) {
                            byteArrayOutputStream.write(chmLzxBlock.getContent(chmBlockInfo.getStartOffset()));
                        }
                        if (n > chmBlockInfo.getStartBlock() && n < chmBlockInfo.getEndBlock()) {
                            byteArrayOutputStream.write(chmLzxBlock.getContent());
                        }
                        if (n == chmBlockInfo.getEndBlock()) {
                            byteArrayOutputStream.write(chmLzxBlock.getContent(0, chmBlockInfo.getEndOffset()));
                            break;
                        }
                        chmLzxBlock = (long)(++n) % this.getChmLzxcControlData().getResetInterval() == 0L ? new ChmLzxBlock(n, ChmCommons.getChmBlockSegment(this.getData(), this.getChmLzxcResetTable(), n, (int)this.getLzxBlockOffset(), (int)this.getLzxBlockLength()), this.getChmLzxcResetTable().getBlockLen(), null) : new ChmLzxBlock(n, ChmCommons.getChmBlockSegment(this.getData(), this.getChmLzxcResetTable(), n, (int)this.getLzxBlockOffset(), (int)this.getLzxBlockLength()), this.getChmLzxcResetTable().getBlockLen(), chmLzxBlock);
                        this.getLzxBlocksCache().add(chmLzxBlock);
                    }
                    if ((long)this.getLzxBlocksCache().size() > this.getChmLzxcResetTable().getBlockCount()) {
                        this.getLzxBlocksCache().clear();
                    }
                }
                if (byteArrayOutputStream.size() != directoryListingEntry.getLength()) {
                    throw new TikaException("CHM file extract error: extracted Length is wrong.");
                }
            }
        }
        catch (Exception exception) {
            throw new TikaException(exception.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void setLzxBlocksCache(List<ChmLzxBlock> list) {
        this.lzxBlocksCache = list;
    }

    private List<ChmLzxBlock> getLzxBlocksCache() {
        return this.lzxBlocksCache;
    }

    private void setChmDirList(ChmDirectoryListingSet chmDirectoryListingSet) {
        this.chmDirList = chmDirectoryListingSet;
    }

    public ChmDirectoryListingSet getChmDirList() {
        return this.chmDirList;
    }

    private void setChmItsfHeader(ChmItsfHeader chmItsfHeader) {
        this.chmItsfHeader = chmItsfHeader;
    }

    private ChmItsfHeader getChmItsfHeader() {
        return this.chmItsfHeader;
    }
}

