/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.lzx;

import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.accessor.ChmLzxcControlData;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmBlockInfo {
    private int iniBlock;
    private int startBlock;
    private int endBlock;
    private int startOffset;
    private int endOffset;
    private static ChmBlockInfo chmBlockInfo = null;

    private ChmBlockInfo() {
    }

    protected ChmBlockInfo getChmBlockInfo(DirectoryListingEntry directoryListingEntry, int n, ChmLzxcControlData chmLzxcControlData, ChmBlockInfo chmBlockInfo) throws TikaException {
        if (!this.validateParameters(directoryListingEntry, n, chmLzxcControlData, chmBlockInfo)) {
            throw new ChmParsingException("Please check you parameters");
        }
        chmBlockInfo.setStartBlock(directoryListingEntry.getOffset() / n);
        chmBlockInfo.setEndBlock((directoryListingEntry.getOffset() + directoryListingEntry.getLength()) / n);
        chmBlockInfo.setStartOffset(directoryListingEntry.getOffset() % n);
        chmBlockInfo.setEndOffset((directoryListingEntry.getOffset() + directoryListingEntry.getLength()) % n);
        chmBlockInfo.setIniBlock(chmBlockInfo.startBlock - chmBlockInfo.startBlock % (int)chmLzxcControlData.getResetInterval());
        return chmBlockInfo;
    }

    public static ChmBlockInfo getChmBlockInfoInstance(DirectoryListingEntry directoryListingEntry, int n, ChmLzxcControlData chmLzxcControlData) {
        ChmBlockInfo.setChmBlockInfo(new ChmBlockInfo());
        ChmBlockInfo.getChmBlockInfo().setStartBlock(directoryListingEntry.getOffset() / n);
        ChmBlockInfo.getChmBlockInfo().setEndBlock((directoryListingEntry.getOffset() + directoryListingEntry.getLength()) / n);
        ChmBlockInfo.getChmBlockInfo().setStartOffset(directoryListingEntry.getOffset() % n);
        ChmBlockInfo.getChmBlockInfo().setEndOffset((directoryListingEntry.getOffset() + directoryListingEntry.getLength()) % n);
        ChmBlockInfo.getChmBlockInfo().setIniBlock(ChmBlockInfo.getChmBlockInfo().startBlock - ChmBlockInfo.getChmBlockInfo().startBlock % (int)chmLzxcControlData.getResetInterval());
        return ChmBlockInfo.getChmBlockInfo();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("iniBlock:=" + this.getIniBlock() + ", ");
        stringBuilder.append("startBlock:=" + this.getStartBlock() + ", ");
        stringBuilder.append("endBlock:=" + this.getEndBlock() + ", ");
        stringBuilder.append("startOffset:=" + this.getStartOffset() + ", ");
        stringBuilder.append("endOffset:=" + this.getEndOffset() + System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    private boolean validateParameters(DirectoryListingEntry directoryListingEntry, int n, ChmLzxcControlData chmLzxcControlData, ChmBlockInfo chmBlockInfo) {
        int n2 = 0;
        if (directoryListingEntry != null) {
            ++n2;
        }
        if (n > 0) {
            ++n2;
        }
        if (chmLzxcControlData != null) {
            ++n2;
        }
        if (chmBlockInfo != null) {
            ++n2;
        }
        return n2 == 4;
    }

    public static void main(String[] stringArray) {
    }

    public int getIniBlock() {
        return this.iniBlock;
    }

    private void setIniBlock(int n) {
        this.iniBlock = n;
    }

    public int getStartBlock() {
        return this.startBlock;
    }

    private void setStartBlock(int n) {
        this.startBlock = n;
    }

    public int getEndBlock() {
        return this.endBlock;
    }

    private void setEndBlock(int n) {
        this.endBlock = n;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    private void setStartOffset(int n) {
        this.startOffset = n;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    private void setEndOffset(int n) {
        this.endOffset = n;
    }

    public static void setChmBlockInfo(ChmBlockInfo chmBlockInfo) {
        ChmBlockInfo.chmBlockInfo = chmBlockInfo;
    }

    public static ChmBlockInfo getChmBlockInfo() {
        return chmBlockInfo;
    }
}

