/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.lzx;

import java.util.concurrent.CancellationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmLzxState
implements Cloneable {
    private int window;
    private long window_size;
    private int window_position;
    private int main_tree_elements;
    private ChmCommons.LzxState hadStarted;
    private int block_type;
    private int block_length;
    private int block_remaining;
    private int frames_read;
    private int intel_file_size;
    private long intel_current_possition;
    private ChmCommons.IntelState intel_state;
    private long R0;
    private long R1;
    private long R2;
    protected short[] mainTreeLengtsTable;
    protected short[] mainTreeTable;
    protected short[] lengthTreeTable;
    protected short[] lengthTreeLengtsTable;
    protected short[] alignedLenTable;
    protected short[] alignedTreeTable;

    public ChmLzxState clone() {
        try {
            ChmLzxState chmLzxState = (ChmLzxState)super.clone();
            chmLzxState.mainTreeLengtsTable = ChmLzxState.arrayClone(this.mainTreeLengtsTable);
            chmLzxState.mainTreeTable = ChmLzxState.arrayClone(this.mainTreeTable);
            chmLzxState.lengthTreeTable = ChmLzxState.arrayClone(this.lengthTreeTable);
            chmLzxState.lengthTreeLengtsTable = ChmLzxState.arrayClone(this.lengthTreeLengtsTable);
            chmLzxState.alignedLenTable = ChmLzxState.arrayClone(this.alignedLenTable);
            chmLzxState.alignedTreeTable = ChmLzxState.arrayClone(this.alignedTreeTable);
            return chmLzxState;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected short[] getMainTreeTable() {
        return this.mainTreeTable;
    }

    protected short[] getAlignedTreeTable() {
        return this.alignedTreeTable;
    }

    protected void setAlignedTreeTable(short[] sArray) {
        this.alignedTreeTable = sArray;
    }

    protected short[] getLengthTreeTable() throws TikaException {
        if (this.lengthTreeTable != null) {
            return this.lengthTreeTable;
        }
        throw new ChmParsingException("lengthTreeTable is null");
    }

    protected void setLengthTreeTable(short[] sArray) {
        this.lengthTreeTable = sArray;
    }

    protected void setMainTreeTable(short[] sArray) {
        this.mainTreeTable = sArray;
    }

    protected short[] getAlignedLenTable() {
        return this.alignedLenTable;
    }

    protected void setAlignedLenTable(short[] sArray) {
        this.alignedLenTable = sArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("actual decoding window:=" + this.getWindow() + System.getProperty("line.separator"));
        stringBuilder.append("window size (32Kb through 2Mb):=" + this.getWindowSize() + System.getProperty("line.separator"));
        stringBuilder.append("current offset within the window:=" + this.getWindowPosition() + System.getProperty("line.separator"));
        stringBuilder.append("number of main tree elements:=" + this.getMainTreeElements() + System.getProperty("line.separator"));
        stringBuilder.append("have we started decoding at all yet?:=" + this.getHadStarted() + System.getProperty("line.separator"));
        stringBuilder.append("type of this block:=" + this.getBlockType() + System.getProperty("line.separator"));
        stringBuilder.append("uncompressed length of this block:=" + this.getBlockLength() + System.getProperty("line.separator"));
        stringBuilder.append("uncompressed bytes still left to decode:=" + this.getBlockRemaining() + System.getProperty("line.separator"));
        stringBuilder.append("the number of CFDATA blocks processed:=" + this.getFramesRead() + System.getProperty("line.separator"));
        stringBuilder.append("magic header value used for transform:=" + this.getIntelFileSize() + System.getProperty("line.separator"));
        stringBuilder.append("current offset in transform space:=" + this.getIntelCurrentPossition() + System.getProperty("line.separator"));
        stringBuilder.append("have we seen any translatable data yet?:=" + this.getIntelState() + System.getProperty("line.separator"));
        stringBuilder.append("R0 for the LRU offset system:=" + this.getR0() + System.getProperty("line.separator"));
        stringBuilder.append("R1 for the LRU offset system:=" + this.getR1() + System.getProperty("line.separator"));
        stringBuilder.append("R2 for the LRU offset system:=" + this.getR2() + System.getProperty("line.separator"));
        stringBuilder.append("main tree length:=" + this.getMainTreeLengtsTable().length + System.getProperty("line.separator"));
        stringBuilder.append("secondary tree length:=" + this.getLengthTreeLengtsTable().length + System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    public ChmLzxState(int n) throws TikaException {
        if (n >= 0) {
            int n2 = ChmCommons.getWindowSize(n);
            this.setWindowSize(1 << n2);
            if (n2 < 15 || n2 > 21) {
                throw new ChmParsingException("window less than 15 or window greater than 21");
            }
            if (n2 == 20) {
                int n3 = 42;
            } else if (n2 == 21) {
                int n4 = 50;
            } else {
                int n5 = n2 << 1;
            }
        } else {
            throw new CancellationException("window size should be more than zero");
        }
        this.setR0(1L);
        this.setR1(1L);
        this.setR2(1L);
        this.setMainTreeElements(512);
        this.setHadStarted(ChmCommons.LzxState.NOT_STARTED_DECODING);
        this.setFramesRead(0);
        this.setBlockRemaining(0);
        this.setBlockType(0);
        this.setIntelCurrentPossition(0L);
        this.setIntelState(ChmCommons.IntelState.NOT_STARTED);
        this.setWindowPosition(0);
        this.setMainTreeLengtsTable(new short[this.getMainTreeElements()]);
        this.setLengthTreeLengtsTable(new short[249]);
    }

    protected void setWindow(int n) {
        this.window = n;
    }

    protected int getWindow() {
        return this.window;
    }

    protected void setWindowSize(long l) {
        this.window_size = l;
    }

    protected long getWindowSize() {
        return this.window_size;
    }

    protected void setWindowPosition(int n) {
        this.window_position = n;
    }

    protected int getWindowPosition() {
        return this.window_position;
    }

    protected void setMainTreeElements(int n) {
        this.main_tree_elements = n;
    }

    protected int getMainTreeElements() {
        return this.main_tree_elements;
    }

    protected void setHadStarted(ChmCommons.LzxState lzxState) {
        this.hadStarted = lzxState;
    }

    protected ChmCommons.LzxState getHadStarted() {
        return this.hadStarted;
    }

    protected void setBlockType(int n) {
        this.block_type = n;
    }

    public int getBlockType() {
        return this.block_type;
    }

    protected void setBlockLength(int n) {
        this.block_length = n;
    }

    protected int getBlockLength() {
        return this.block_length;
    }

    protected void setBlockRemaining(int n) {
        this.block_remaining = n;
    }

    protected int getBlockRemaining() {
        return this.block_remaining;
    }

    protected void setFramesRead(int n) {
        this.frames_read = n;
    }

    protected void increaseFramesRead() {
        this.frames_read = this.getFramesRead() + 1;
    }

    protected int getFramesRead() {
        return this.frames_read;
    }

    protected void setIntelFileSize(int n) {
        this.intel_file_size = n;
    }

    protected int getIntelFileSize() {
        return this.intel_file_size;
    }

    protected void setIntelCurrentPossition(long l) {
        this.intel_current_possition = l;
    }

    protected long getIntelCurrentPossition() {
        return this.intel_current_possition;
    }

    protected void setIntelState(ChmCommons.IntelState intelState) {
        this.intel_state = intelState;
    }

    protected ChmCommons.IntelState getIntelState() {
        return this.intel_state;
    }

    protected void setR0(long l) {
        this.R0 = l;
    }

    protected long getR0() {
        return this.R0;
    }

    protected void setR1(long l) {
        this.R1 = l;
    }

    protected long getR1() {
        return this.R1;
    }

    protected void setR2(long l) {
        this.R2 = l;
    }

    protected long getR2() {
        return this.R2;
    }

    public void setMainTreeLengtsTable(short[] sArray) {
        this.mainTreeLengtsTable = sArray;
    }

    public short[] getMainTreeLengtsTable() {
        return this.mainTreeLengtsTable;
    }

    public void setLengthTreeLengtsTable(short[] sArray) {
        this.lengthTreeLengtsTable = sArray;
    }

    public short[] getLengthTreeLengtsTable() {
        return this.lengthTreeLengtsTable;
    }

    private static short[] arrayClone(short[] sArray) {
        return sArray == null ? null : (short[])sArray.clone();
    }
}

