/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.lzx;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.chm.core.ChmCommons;

public class ChmSection {
    private final byte[] data;
    private final byte[] prevcontent;
    private int swath;
    private int total;
    private int buffer;

    public ChmSection(byte[] byArray) throws TikaException {
        this(byArray, null);
    }

    public ChmSection(byte[] byArray, byte[] byArray2) throws TikaException {
        ChmCommons.assertByteArrayNotNull(byArray);
        this.data = byArray;
        this.prevcontent = byArray2;
    }

    public byte[] reverseByteOrder(byte[] byArray) throws TikaException {
        ChmCommons.assertByteArrayNotNull(byArray);
        ChmCommons.reverse(byArray);
        return byArray;
    }

    public int checkBit(int n) {
        return (this.getBuffer() & 1 << this.getTotal() - n) == 0 ? 0 : 1;
    }

    public int getSyncBits(int n) {
        return this.getDesyncBits(n, n);
    }

    public int peekBits(int n) {
        return this.getDesyncBits(n, 0);
    }

    private int getDesyncBits(int n, int n2) {
        while (this.getTotal() < 16) {
            this.setBuffer((this.getBuffer() << 16) + this.unmarshalUByte() + (this.unmarshalUByte() << 8));
            this.setTotal(this.getTotal() + 16);
        }
        int n3 = this.getBuffer() >>> this.getTotal() - n;
        this.setTotal(this.getTotal() - n2);
        this.setBuffer(this.getBuffer() - (this.getBuffer() >>> this.getTotal() << this.getTotal()));
        return n3;
    }

    public int unmarshalUByte() {
        return this.getByte() & 0xFF;
    }

    public byte getByte() {
        if (this.getSwath() < this.getData().length) {
            this.setSwath(this.getSwath() + 1);
            return this.getData()[this.getSwath() - 1];
        }
        return 0;
    }

    public int getLeft() {
        return this.getData().length - this.getSwath();
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getPrevContent() {
        return this.prevcontent;
    }

    public BigInteger getBigInteger(int n) {
        if (this.getData() == null) {
            return BigInteger.ZERO;
        }
        if (this.getData().length - this.getSwath() < n) {
            n = this.getData().length - this.getSwath();
        }
        byte[] byArray = new byte[n];
        for (int i = n - 1; i >= 0; --i) {
            byArray[n - i - 1] = this.getData()[this.getSwath() + i];
        }
        this.setSwath(this.getSwath() + n);
        return new BigInteger(byArray);
    }

    public byte[] stringToAsciiBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public BigInteger unmarshalUlong() {
        return this.getBigInteger(8);
    }

    public long unmarshalUInt() {
        return this.getBigInteger(4).longValue();
    }

    public int unmarshalInt() {
        return this.getBigInteger(4).intValue();
    }

    public byte[] unmarshalBytes(int n) {
        if (n == 0) {
            return new byte[1];
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.getData()[i + this.getSwath()];
        }
        this.setSwath(this.getSwath() + n);
        return byArray;
    }

    public BigInteger getEncint() {
        byte by;
        BigInteger bigInteger = BigInteger.ZERO;
        byte[] byArray = new byte[1];
        while ((by = this.getByte()) < 0) {
            byArray[0] = (byte)(by & 0x7F);
            bigInteger = bigInteger.shiftLeft(7).add(new BigInteger(byArray));
        }
        byArray[0] = (byte)(by & 0x7F);
        bigInteger = bigInteger.shiftLeft(7).add(new BigInteger(byArray));
        return bigInteger;
    }

    public char unmarshalUtfChar() {
        int n;
        int n2 = 1;
        byte by = this.getByte();
        if (by < 0) {
            n2 = 2;
            while (by << 24 + n2 < 0) {
                ++n2;
            }
        }
        byte[] byArray = new byte[n2];
        byArray[0] = by;
        for (n = 1; n < n2; ++n) {
            byArray[n] = this.getByte();
        }
        n2 = byArray.length;
        if (n2 == 1) {
            return (char)byArray[0];
        }
        int n3 = byArray[0] & 0xF;
        n = 1;
        while (n < n2) {
            n3 = (n3 << 6) + (byArray[n++] & 0x3F);
        }
        return (char)n3;
    }

    public int getSwath() {
        return this.swath;
    }

    public void setSwath(int n) {
        this.swath = n;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int n) {
        this.total = n;
    }

    private int getBuffer() {
        return this.buffer;
    }

    private void setBuffer(int n) {
        this.buffer = n;
    }

    public static void main(String[] stringArray) throws TikaException {
        byte[] byArray = new byte[]{4, 78, -67, 90, 1, -33};
        ChmSection chmSection = new ChmSection(byArray);
        System.out.println("before " + Arrays.toString(byArray));
        System.out.println("after " + Arrays.toString(chmSection.reverseByteOrder(byArray)));
    }
}

