/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.NullOutputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExternalParser
extends AbstractParser {
    private static final long serialVersionUID = -1079128990650687037L;
    public static final String INPUT_FILE_TOKEN = "${INPUT}";
    public static final String OUTPUT_FILE_TOKEN = "${OUTPUT}";
    private Set<MediaType> supportedTypes = Collections.emptySet();
    private Map<Pattern, String> metadataPatterns = null;
    private String[] command = new String[]{"cat"};

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.getSupportedTypes();
    }

    public Set<MediaType> getSupportedTypes() {
        return this.supportedTypes;
    }

    public void setSupportedTypes(Set<MediaType> set) {
        this.supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(set));
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String ... stringArray) {
        this.command = stringArray;
    }

    public Map<Pattern, String> getMetadataExtractionPatterns() {
        return this.metadataPatterns;
    }

    public void setMetadataExtractionPatterns(Map<Pattern, String> map) {
        this.metadataPatterns = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xHTMLContentHandler = new XHTMLContentHandler(contentHandler, metadata);
        TemporaryResources temporaryResources = new TemporaryResources();
        try {
            this.parse(TikaInputStream.get(inputStream, temporaryResources), xHTMLContentHandler, metadata, temporaryResources);
        }
        finally {
            temporaryResources.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(TikaInputStream tikaInputStream, XHTMLContentHandler xHTMLContentHandler, Metadata metadata, TemporaryResources temporaryResources) throws IOException, SAXException, TikaException {
        String[] stringArray;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = this.metadataPatterns != null && !this.metadataPatterns.isEmpty();
        File file = null;
        if (this.command.length == 1) {
            stringArray = this.command[0].split(" ");
        } else {
            stringArray = new String[this.command.length];
            System.arraycopy(this.command, 0, stringArray, 0, this.command.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(INPUT_FILE_TOKEN) != -1) {
                stringArray[i] = stringArray[i].replace(INPUT_FILE_TOKEN, tikaInputStream.getFile().getPath());
                bl = false;
            }
            if (stringArray[i].indexOf(OUTPUT_FILE_TOKEN) == -1) continue;
            file = temporaryResources.createTemporaryFile();
            bl2 = false;
            stringArray[i] = stringArray[i].replace(OUTPUT_FILE_TOKEN, file.getPath());
        }
        Process process = null;
        try {
            process = stringArray.length == 1 ? Runtime.getRuntime().exec(stringArray[0]) : Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (bl) {
                this.sendInput(process, tikaInputStream);
            } else {
                process.getOutputStream().close();
            }
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            if (bl3) {
                this.extractMetadata(inputStream2, metadata);
                if (bl2) {
                    this.extractOutput(inputStream, xHTMLContentHandler);
                } else {
                    this.extractMetadata(inputStream, metadata);
                }
            } else {
                this.ignoreStream(inputStream2);
                if (bl2) {
                    this.extractOutput(inputStream, xHTMLContentHandler);
                } else {
                    this.ignoreStream(inputStream);
                }
            }
        }
        finally {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!bl2) {
            this.extractOutput(new FileInputStream(file), xHTMLContentHandler);
        }
    }

    private void extractOutput(InputStream inputStream, XHTMLContentHandler xHTMLContentHandler) throws SAXException, IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            xHTMLContentHandler.startDocument();
            xHTMLContentHandler.startElement("p");
            char[] cArray = new char[1024];
            int n = inputStreamReader.read(cArray);
            while (n != -1) {
                xHTMLContentHandler.characters(cArray, 0, n);
                n = inputStreamReader.read(cArray);
            }
            xHTMLContentHandler.endElement("p");
            xHTMLContentHandler.endDocument();
        }
    }

    private void sendInput(final Process process, final InputStream inputStream) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                OutputStream outputStream = process.getOutputStream();
                try {
                    IOUtils.copy(inputStream, outputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void ignoreStream(final InputStream inputStream) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    IOUtils.copy(inputStream, (OutputStream)new NullOutputStream());
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.closeQuietly(inputStream);
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void extractMetadata(final InputStream inputStream, final Metadata metadata) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        for (Pattern pattern : ExternalParser.this.metadataPatterns.keySet()) {
                            Matcher matcher = pattern.matcher(string);
                            if (!matcher.find()) continue;
                            if (ExternalParser.this.metadataPatterns.get(pattern) != null && !ExternalParser.this.metadataPatterns.get(pattern).equals("")) {
                                metadata.add(ExternalParser.this.metadataPatterns.get(pattern), matcher.group(1));
                                continue;
                            }
                            metadata.add(matcher.group(1), matcher.group(2));
                        }
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.closeQuietly(bufferedReader);
                    IOUtils.closeQuietly(inputStream);
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean check(String string, int ... nArray) {
        return ExternalParser.check(new String[]{string}, nArray);
    }

    public static boolean check(String[] stringArray, int ... nArray) {
        if (nArray.length == 0) {
            nArray = new int[]{127};
        }
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            int n = process.waitFor();
            for (int n2 : nArray) {
                if (n != n2) continue;
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (Error error) {
            if (error.getMessage() != null && (error.getMessage().contains("posix_spawn") || error.getMessage().contains("UNIXProcess"))) {
                return false;
            }
            throw error;
        }
    }
}

