/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.external.ExternalParsersConfigReaderMetKeys;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ExternalParsersConfigReader
implements ExternalParsersConfigReaderMetKeys {
    public static List<ExternalParser> read(InputStream inputStream) throws TikaException, IOException {
        try {
            DocumentBuilder documentBuilder = new ParseContext().getDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            return ExternalParsersConfigReader.read(document);
        }
        catch (SAXException sAXException) {
            throw new TikaException("Invalid parser configuration", sAXException);
        }
    }

    public static List<ExternalParser> read(Document document) throws TikaException, IOException {
        return ExternalParsersConfigReader.read(document.getDocumentElement());
    }

    public static List<ExternalParser> read(Element element) throws TikaException, IOException {
        ArrayList<ExternalParser> arrayList = new ArrayList<ExternalParser>();
        if (element != null && element.getTagName().equals("external-parsers")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ExternalParser externalParser;
                Element element2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals("parser") || (externalParser = ExternalParsersConfigReader.readParser(element2)) == null) continue;
                arrayList.add(externalParser);
            }
        } else {
            throw new MimeTypeException("Not a <external-parsers/> configuration document: " + element.getTagName());
        }
        return arrayList;
    }

    private static ExternalParser readParser(Element element) throws TikaException {
        ExternalParser externalParser = new ExternalParser();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            if (element2.getTagName().equals("check")) {
                boolean bl = ExternalParsersConfigReader.readCheckTagAndCheck(element2);
                if (bl) continue;
                return null;
            }
            if (element2.getTagName().equals("command")) {
                externalParser.setCommand(ExternalParsersConfigReader.getString(element2));
                continue;
            }
            if (element2.getTagName().equals("mime-types")) {
                externalParser.setSupportedTypes(ExternalParsersConfigReader.readMimeTypes(element2));
                continue;
            }
            if (!element2.getTagName().equals("metadata")) continue;
            externalParser.setMetadataExtractionPatterns(ExternalParsersConfigReader.readMetadataPatterns(element2));
        }
        return externalParser;
    }

    private static Set<MediaType> readMimeTypes(Element element) {
        HashSet<MediaType> hashSet = new HashSet<MediaType>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals("mime-type")) continue;
            hashSet.add(MediaType.parse(ExternalParsersConfigReader.getString(element2)));
        }
        return hashSet;
    }

    private static Map<Pattern, String> readMetadataPatterns(Element element) {
        HashMap<Pattern, String> hashMap = new HashMap<Pattern, String>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals("match")) continue;
            String string = element2.getAttribute("key");
            Pattern pattern = Pattern.compile(ExternalParsersConfigReader.getString(element2));
            hashMap.put(pattern, string);
        }
        return hashMap;
    }

    private static boolean readCheckTagAndCheck(Element element) {
        Object object;
        String string = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            if (object.getNodeType() != 1) continue;
            Element element2 = (Element)object;
            if (element2.getTagName().equals("command")) {
                string = ExternalParsersConfigReader.getString(element2);
            }
            if (!element2.getTagName().equals("error-codes")) continue;
            String string2 = ExternalParsersConfigReader.getString(element2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreElements()) {
                try {
                    String string3 = stringTokenizer.nextToken();
                    arrayList.add(Integer.parseInt(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (string != null) {
            String[] stringArray = string.split(" ");
            object = new int[arrayList.size()];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            return ExternalParser.check(stringArray, (int[])object);
        }
        return true;
    }

    private static String getString(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            stringBuffer.append(node.getNodeValue());
        }
        return stringBuffer.toString();
    }
}

