/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.external;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.external.ExternalParsersConfigReader;

public class ExternalParsersFactory {
    public static List<ExternalParser> create() throws IOException, TikaException {
        return ExternalParsersFactory.create(new ServiceLoader());
    }

    public static List<ExternalParser> create(ServiceLoader serviceLoader) throws IOException, TikaException {
        return ExternalParsersFactory.create("tika-external-parsers.xml", serviceLoader);
    }

    public static List<ExternalParser> create(String string, ServiceLoader serviceLoader) throws IOException, TikaException {
        String string2 = ExternalParsersFactory.class.getPackage().getName().replace('.', '/') + "/" + string;
        Enumeration<URL> enumeration = serviceLoader.findServiceResources(string2);
        ArrayList<URL> arrayList = Collections.list(enumeration);
        URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        return ExternalParsersFactory.create(uRLArray);
    }

    public static List<ExternalParser> create(URL ... uRLArray) throws IOException, TikaException {
        ArrayList<ExternalParser> arrayList = new ArrayList<ExternalParser>();
        for (URL uRL : uRLArray) {
            try (InputStream inputStream = uRL.openStream();){
                arrayList.addAll(ExternalParsersConfigReader.read(inputStream));
            }
        }
        return arrayList;
    }

    public static void attachExternalParsers(TikaConfig tikaConfig) throws IOException, TikaException {
        ExternalParsersFactory.attachExternalParsers(ExternalParsersFactory.create(), tikaConfig);
    }

    public static void attachExternalParsers(List<ExternalParser> list, TikaConfig tikaConfig) {
        Parser parser = tikaConfig.getParser();
        if (parser instanceof CompositeParser) {
            CompositeParser compositeParser = (CompositeParser)parser;
            Map<MediaType, Parser> map = compositeParser.getParsers();
        }
    }
}

