/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.HashSet;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.microsoft.POIFSContainerDetector;

public class OfficeParser {

    public static enum POIFSDocumentType {
        WORKBOOK("xls", MediaType.application("vnd.ms-excel")),
        OLE10_NATIVE("ole", POIFSContainerDetector.OLE10_NATIVE),
        COMP_OBJ("ole", POIFSContainerDetector.COMP_OBJ),
        WORDDOCUMENT("doc", MediaType.application("msword")),
        UNKNOWN("unknown", MediaType.application("x-tika-msoffice")),
        ENCRYPTED("ole", MediaType.application("x-tika-ooxml-protected")),
        POWERPOINT("ppt", MediaType.application("vnd.ms-powerpoint")),
        PUBLISHER("pub", MediaType.application("x-mspublisher")),
        PROJECT("mpp", MediaType.application("vnd.ms-project")),
        VISIO("vsd", MediaType.application("vnd.visio")),
        WORKS("wps", MediaType.application("vnd.ms-works")),
        XLR("xlr", MediaType.application("x-tika-msworks-spreadsheet")),
        OUTLOOK("msg", MediaType.application("vnd.ms-outlook")),
        SOLIDWORKS_PART("sldprt", MediaType.application("sldworks")),
        SOLIDWORKS_ASSEMBLY("sldasm", MediaType.application("sldworks")),
        SOLIDWORKS_DRAWING("slddrw", MediaType.application("sldworks"));

        private final String extension;
        private final MediaType type;

        private POIFSDocumentType(String string2, MediaType mediaType) {
            this.extension = string2;
            this.type = mediaType;
        }

        public static POIFSDocumentType detectType(POIFSFileSystem pOIFSFileSystem) {
            return POIFSDocumentType.detectType((DirectoryEntry)pOIFSFileSystem.getRoot());
        }

        public static POIFSDocumentType detectType(NPOIFSFileSystem nPOIFSFileSystem) {
            return POIFSDocumentType.detectType((DirectoryEntry)nPOIFSFileSystem.getRoot());
        }

        public static POIFSDocumentType detectType(DirectoryEntry directoryEntry) {
            HashSet<String> hashSet = new HashSet<String>();
            for (POIFSDocumentType[] pOIFSDocumentTypeArray : directoryEntry) {
                hashSet.add(pOIFSDocumentTypeArray.getName());
            }
            MediaType mediaType = POIFSContainerDetector.detect(hashSet, directoryEntry);
            for (POIFSDocumentType pOIFSDocumentType : POIFSDocumentType.values()) {
                if (!mediaType.equals(pOIFSDocumentType.type)) continue;
                return pOIFSDocumentType;
            }
            return UNKNOWN;
        }

        public String getExtension() {
            return this.extension;
        }

        public MediaType getType() {
            return this.type;
        }
    }
}

