/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class POIFSContainerDetector
implements Detector {
    public static final MediaType OLE = MediaType.application("x-tika-msoffice");
    public static final MediaType OOXML_PROTECTED = MediaType.application("x-tika-ooxml-protected");
    public static final MediaType GENERAL_EMBEDDED = MediaType.application("x-tika-msoffice-embedded");
    public static final MediaType OLE10_NATIVE = new MediaType(GENERAL_EMBEDDED, "format", "ole10_native");
    public static final MediaType COMP_OBJ = new MediaType(GENERAL_EMBEDDED, "format", "comp_obj");
    public static final MediaType MS_GRAPH_CHART = MediaType.application("vnd.ms-graph");
    public static final MediaType XLS = MediaType.application("vnd.ms-excel");
    public static final MediaType DOC = MediaType.application("msword");
    public static final MediaType PPT = MediaType.application("vnd.ms-powerpoint");
    public static final MediaType PUB = MediaType.application("x-mspublisher");
    public static final MediaType VSD = MediaType.application("vnd.visio");
    public static final MediaType WPS = MediaType.application("vnd.ms-works");
    public static final MediaType XLR = MediaType.application("x-tika-msworks-spreadsheet");
    public static final MediaType MSG = MediaType.application("vnd.ms-outlook");
    public static final MediaType MPP = MediaType.application("vnd.ms-project");
    public static final MediaType SDC = MediaType.application("vnd.stardivision.calc");
    public static final MediaType SDA = MediaType.application("vnd.stardivision.draw");
    public static final MediaType SDD = MediaType.application("vnd.stardivision.impress");
    public static final MediaType SDW = MediaType.application("vnd.stardivision.writer");
    public static final MediaType SLDWORKS = MediaType.application("sldworks");
    public static final MediaType HWP = MediaType.application("x-hwp-v5");
    private static final long serialVersionUID = -3028021741663605293L;
    private static final byte[] STAR_IMPRESS = new byte[]{83, 116, 97, 114, 73, 109, 112, 114, 101, 115, 115};
    private static final byte[] STAR_DRAW = new byte[]{83, 116, 97, 114, 68, 114, 97, 119};
    private static final byte[] WORKS_QUILL96 = new byte[]{81, 117, 105, 108, 108, 57, 54};
    private static final byte[] MS_GRAPH_CHART_BYTES = new byte[]{77, 83, 71, 114, 97, 112, 104, 46, 67, 104, 97, 114, 116};
    private static final Pattern mppDataMatch = Pattern.compile("\\s\\s\\s\\d+");

    protected static MediaType detect(Set<String> set) {
        return POIFSContainerDetector.detect(set, null);
    }

    protected static MediaType detect(Set<String> set, DirectoryEntry directoryEntry) {
        block33: {
            if (set == null) break block33;
            if (set.contains("SwDocContentMgr") && set.contains("SwDocMgrTempStorage")) {
                return SLDWORKS;
            }
            if (set.contains("StarCalcDocument")) {
                return SDC;
            }
            if (set.contains("StarWriterDocument")) {
                return SDW;
            }
            if (set.contains("StarDrawDocument3")) {
                if (directoryEntry == null) {
                    return OLE;
                }
                return POIFSContainerDetector.processCompObjFormatType(directoryEntry);
            }
            if (set.contains("\u0005HwpSummaryInformation")) {
                return HWP;
            }
            if (set.contains("WksSSWorkBook")) {
                return XLR;
            }
            if (set.contains("Workbook") || set.contains("WORKBOOK")) {
                MediaType mediaType = POIFSContainerDetector.processCompObjFormatType(directoryEntry);
                if (mediaType.equals(MS_GRAPH_CHART)) {
                    return MS_GRAPH_CHART;
                }
                return XLS;
            }
            if (set.contains("Book")) {
                return XLS;
            }
            if (set.contains("EncryptedPackage") && set.contains("EncryptionInfo") && set.contains("\u0006DataSpaces")) {
                return OOXML_PROTECTED;
            }
            if (set.contains("EncryptedPackage")) {
                return OLE;
            }
            if (set.contains("WordDocument")) {
                return DOC;
            }
            if (set.contains("Quill")) {
                return PUB;
            }
            if (set.contains("PowerPoint Document")) {
                return PPT;
            }
            if (set.contains("VisioDocument")) {
                return VSD;
            }
            if (set.contains("\u0001Ole10Native")) {
                return OLE10_NATIVE;
            }
            if (set.contains("MatOST")) {
                return WPS;
            }
            if (set.contains("CONTENTS") && set.contains("SPELLING")) {
                return WPS;
            }
            if (set.contains("Contents") && set.contains("\u0003ObjInfo")) {
                return COMP_OBJ;
            }
            if (set.contains("CONTENTS") && set.contains("\u0001CompObj")) {
                if (directoryEntry != null) {
                    MediaType mediaType = POIFSContainerDetector.processCompObjFormatType(directoryEntry);
                    if (mediaType == WPS) {
                        return WPS;
                    }
                    return COMP_OBJ;
                }
                return COMP_OBJ;
            }
            if (set.contains("CONTENTS")) {
                return OLE;
            }
            if (set.contains("\u0001CompObj") && (set.contains("Props") || set.contains("Props9") || set.contains("Props12"))) {
                for (String string : set) {
                    if (!mppDataMatch.matcher(string).matches()) continue;
                    return MPP;
                }
            } else if (set.contains("PerfectOffice_MAIN")) {
                if (set.contains("SlideShow")) {
                    return MediaType.application("x-corelpresentations");
                }
                if (set.contains("PerfectOffice_OBJECTS")) {
                    return MediaType.application("x-quattro-pro");
                }
            } else {
                if (set.contains("NativeContent_MAIN")) {
                    return MediaType.application("x-quattro-pro");
                }
                for (String string : set) {
                    if (!string.startsWith("__substg1.0_")) continue;
                    return MSG;
                }
            }
        }
        return OLE;
    }

    private static MediaType processCompObjFormatType(DirectoryEntry directoryEntry) {
        try {
            Entry entry = directoryEntry.getEntry("\u0001CompObj");
            if (entry != null && entry.isDocumentEntry()) {
                DocumentNode documentNode = (DocumentNode)entry;
                DocumentInputStream documentInputStream = new DocumentInputStream((DocumentEntry)documentNode);
                byte[] byArray = IOUtils.toByteArray((InputStream)documentInputStream);
                if (POIFSContainerDetector.arrayContains(byArray, MS_GRAPH_CHART_BYTES)) {
                    return MS_GRAPH_CHART;
                }
                if (POIFSContainerDetector.arrayContains(byArray, STAR_DRAW)) {
                    return SDA;
                }
                if (POIFSContainerDetector.arrayContains(byArray, STAR_IMPRESS)) {
                    return SDD;
                }
                if (POIFSContainerDetector.arrayContains(byArray, WORKS_QUILL96)) {
                    return WPS;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OLE;
    }

    private static boolean arrayContains(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            if (byArray[n] == byArray2[n2]) {
                ++n;
                if (++n2 != byArray2.length) continue;
                return true;
            }
            n = n - n2 + 1;
            n2 = 0;
        }
        return false;
    }

    private static Set<String> getTopLevelNames(TikaInputStream tikaInputStream) throws IOException {
        File file = tikaInputStream.getFile();
        try {
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(file, true);
            tikaInputStream.setOpenContainer(nPOIFSFileSystem);
            return POIFSContainerDetector.getTopLevelNames(nPOIFSFileSystem.getRoot());
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
        catch (RuntimeException runtimeException) {
            return Collections.emptySet();
        }
    }

    private static Set<String> getTopLevelNames(DirectoryNode directoryNode) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Entry entry : directoryNode) {
            hashSet.add(entry.getName());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
        Object object;
        if (inputStream == null) {
            return MediaType.OCTET_STREAM;
        }
        TikaInputStream tikaInputStream = TikaInputStream.cast(inputStream);
        Set<String> set = null;
        if (tikaInputStream != null) {
            object = tikaInputStream.getOpenContainer();
            if (object instanceof NPOIFSFileSystem) {
                set = POIFSContainerDetector.getTopLevelNames(((NPOIFSFileSystem)object).getRoot());
            } else if (object instanceof DirectoryNode) {
                set = POIFSContainerDetector.getTopLevelNames((DirectoryNode)object);
            }
        }
        if (set == null) {
            inputStream.mark(8);
            try {
                if (inputStream.read() != 208 || inputStream.read() != 207 || inputStream.read() != 17 || inputStream.read() != 224 || inputStream.read() != 161 || inputStream.read() != 177 || inputStream.read() != 26 || inputStream.read() != 225) {
                    object = MediaType.OCTET_STREAM;
                    return object;
                }
            }
            finally {
                inputStream.reset();
            }
        }
        if (set == null && tikaInputStream != null) {
            set = POIFSContainerDetector.getTopLevelNames(tikaInputStream);
        }
        if (tikaInputStream != null && tikaInputStream.getOpenContainer() != null && tikaInputStream.getOpenContainer() instanceof NPOIFSFileSystem) {
            return POIFSContainerDetector.detect(set, (DirectoryEntry)((NPOIFSFileSystem)tikaInputStream.getOpenContainer()).getRoot());
        }
        return POIFSContainerDetector.detect(set, null);
    }
}

