/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.MP3Frame;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AudioFrame
implements MP3Frame {
    public static final int MPEG_V1 = 3;
    public static final int MPEG_V2 = 2;
    public static final int MPEG_V2_5 = 0;
    public static final int LAYER_1 = 3;
    public static final int LAYER_2 = 2;
    public static final int LAYER_3 = 1;
    private final String version;
    private final int versionCode;
    private final int layer;
    private final int sampleRate;
    private final int channels;
    private final int bitRate;
    private final int length;
    private final float duration;

    public String getVersion() {
        return this.version;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getLength() {
        return this.length;
    }

    public float getDuration() {
        return this.duration;
    }

    public static boolean isAudioHeader(int n, int n2, int n3, int n4) {
        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
            return false;
        }
        return n == 255 && (n2 & 0x60) == 96;
    }

    @Deprecated
    public AudioFrame(InputStream inputStream, ContentHandler contentHandler) throws IOException, SAXException, TikaException {
        this(-2, -2, -2, -2, inputStream);
    }

    @Deprecated
    public AudioFrame(int n, int n2, int n3, int n4, InputStream inputStream) throws IOException {
        int n5;
        if (n == -2 && n2 == -2 && n3 == -2 && n4 == -2) {
            n = inputStream.read();
            n2 = inputStream.read();
            n3 = inputStream.read();
            n4 = inputStream.read();
        }
        if (AudioFrame.isAudioHeader(n, n2, n3, n4)) {
            this.layer = n2 >> 1 & 3;
            this.versionCode = n2 >> 3 & 3;
            this.version = AudioFrame.generateVersionStr(this.versionCode, this.layer);
            int n6 = n3 >> 2 & 3;
            switch (n6) {
                case 0: {
                    n5 = 11025;
                    break;
                }
                case 1: {
                    n5 = 12000;
                    break;
                }
                default: {
                    n5 = 8000;
                }
            }
            if (this.versionCode == 2) {
                n5 *= 2;
            } else if (this.versionCode == 3) {
                n5 *= 4;
            }
        } else {
            throw new IllegalArgumentException("Magic Audio Frame Header not found");
        }
        this.sampleRate = n5;
        int n7 = n4 & 0x192;
        this.channels = n7 < 3 ? 2 : 1;
        this.bitRate = 0;
        this.duration = 0.0f;
        this.length = 0;
    }

    public AudioFrame(int n, int n2, int n3, int n4, int n5, int n6, float f) {
        this.versionCode = n;
        this.layer = n2;
        this.bitRate = n3;
        this.sampleRate = n4;
        this.channels = n5;
        this.length = n6;
        this.duration = f;
        this.version = AudioFrame.generateVersionStr(n, n2);
    }

    private static String generateVersionStr(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("MPEG 3 Layer ");
        if (n2 == 1) {
            stringBuilder.append("III");
        } else if (n2 == 2) {
            stringBuilder.append("II");
        } else if (n2 == 3) {
            stringBuilder.append("I");
        } else {
            stringBuilder.append("(reserved)");
        }
        stringBuilder.append(" Version ");
        if (n == 0) {
            stringBuilder.append("2.5");
        } else if (n == 2) {
            stringBuilder.append("2");
        } else if (n == 3) {
            stringBuilder.append("1");
        } else {
            stringBuilder.append("(reseved)");
        }
        return stringBuilder.toString();
    }
}

