/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v22Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String genre;
    private String trackNumber;
    private String albumArtist;
    private String disc;
    private List<ID3Tags.ID3Comment> comments = new ArrayList<ID3Tags.ID3Comment>();

    public ID3v22Handler(ID3v2Frame iD3v2Frame) throws IOException, SAXException, TikaException {
        RawV22TagIterator rawV22TagIterator = new RawV22TagIterator(iD3v2Frame);
        while (rawV22TagIterator.hasNext()) {
            ID3v2Frame.RawTag rawTag = rawV22TagIterator.next();
            if (rawTag.name.equals("TT2")) {
                this.title = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TP1")) {
                this.artist = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TP2")) {
                this.albumArtist = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TAL")) {
                this.album = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TYE")) {
                this.year = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TCM")) {
                this.composer = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("COM")) {
                this.comments.add(this.getComment(rawTag.data, 0, rawTag.data.length));
                continue;
            }
            if (rawTag.name.equals("TRK")) {
                this.trackNumber = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (rawTag.name.equals("TPA")) {
                this.disc = this.getTagString(rawTag.data, 0, rawTag.data.length);
                continue;
            }
            if (!rawTag.name.equals("TCO")) continue;
            this.genre = ID3v22Handler.extractGenre(this.getTagString(rawTag.data, 0, rawTag.data.length));
        }
    }

    private String getTagString(byte[] byArray, int n, int n2) {
        return ID3v2Frame.getTagString(byArray, n, n2);
    }

    private ID3Tags.ID3Comment getComment(byte[] byArray, int n, int n2) {
        return ID3v2Frame.getComment(byArray, n, n2);
    }

    protected static String extractGenre(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n == -1 && n2 == -1) {
            return string;
        }
        if (n < n2) {
            String string2 = string.substring(0, n).trim();
            try {
                int n3 = Integer.parseInt(string.substring(n + 1, n2));
                return ID3Tags.GENRES[n3];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return string2;
            }
            catch (NumberFormatException numberFormatException) {
                return string2;
            }
        }
        return null;
    }

    @Override
    public boolean getTagsPresent() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public String getComposer() {
        return this.composer;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public String getAlbumArtist() {
        return this.albumArtist;
    }

    @Override
    public String getDisc() {
        return this.disc;
    }

    @Override
    public String getCompilation() {
        return null;
    }

    private class RawV22TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV22TagIterator(ID3v2Frame iD3v2Frame) {
            ID3v2Frame iD3v2Frame2 = iD3v2Frame;
            Objects.requireNonNull(iD3v2Frame2);
            super(iD3v2Frame2, 3, 3, 1, 0);
        }
    }
}

