/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NSNormalizerContentHandler
extends ContentHandlerDecorator {
    private static final String OLD_NS = "http://openoffice.org/2000/";
    private static final String NEW_NS = "urn:oasis:names:tc:opendocument:xmlns:";
    private static final String DTD_PUBLIC_ID = "-//OpenOffice.org//DTD OfficeDocument 1.0//EN";

    public NSNormalizerContentHandler(ContentHandler contentHandler) {
        super(contentHandler);
    }

    private String mapOldNS(String string) {
        if (string != null && string.startsWith(OLD_NS)) {
            return NEW_NS + string.substring(OLD_NS.length()) + ":1.0";
        }
        return string;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributesImpl.addAttribute(this.mapOldNS(attributes.getURI(i)), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        super.startElement(this.mapOldNS(string), string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(this.mapOldNS(string), string2, string3);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, this.mapOldNS(string2));
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        if (string2 != null && string2.toLowerCase(Locale.ROOT).endsWith(".dtd") || DTD_PUBLIC_ID.equals(string)) {
            return new InputSource(new StringReader(""));
        }
        return super.resolveEntity(string, string2);
    }
}

