/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.sax.ElementMappingContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class OpenDocumentContentParser
extends AbstractParser {
    public static final String TEXT_NS = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    public static final String TABLE_NS = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    public static final String STYLE_NS = "urn:oasis:names:tc:opendocument:xmlns:style:1.0";
    public static final String FORMATTING_OBJECTS_NS = "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0";
    public static final String OFFICE_NS = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    public static final String SVG_NS = "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0";
    public static final String PRESENTATION_NS = "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0";
    public static final String DRAW_NS = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    public static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    protected static final char[] TAB = new char[]{'\t'};
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private static final HashMap<QName, ElementMappingContentHandler.TargetElement> MAPPINGS = new HashMap();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return Collections.emptySet();
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        this.parseInternal(inputStream, new XHTMLContentHandler(contentHandler, metadata), metadata, parseContext);
    }

    void parseInternal(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        OpenDocumentElementMappingContentHandler openDocumentElementMappingContentHandler = new OpenDocumentElementMappingContentHandler(contentHandler, MAPPINGS);
        SAXParser sAXParser = parseContext.getSAXParser();
        sAXParser.parse((InputStream)new CloseShieldInputStream(inputStream), (DefaultHandler)new OfflineContentHandler(new NSNormalizerContentHandler(openDocumentElementMappingContentHandler)));
    }

    static {
        MAPPINGS.put(new QName(TEXT_NS, "p"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "p"));
        MAPPINGS.put(new QName(TEXT_NS, "line-break"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "br"));
        MAPPINGS.put(new QName(TEXT_NS, "list-item"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "li"));
        MAPPINGS.put(new QName(TEXT_NS, "note"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(OFFICE_NS, "annotation"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(PRESENTATION_NS, "notes"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(DRAW_NS, "object"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "object"));
        MAPPINGS.put(new QName(DRAW_NS, "text-box"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(SVG_NS, "title"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        MAPPINGS.put(new QName(SVG_NS, "desc"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        MAPPINGS.put(new QName(TEXT_NS, "span"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        HashMap<QName, QName> hashMap = new HashMap<QName, QName>();
        hashMap.put(new QName(XLINK_NS, "href"), new QName("href"));
        hashMap.put(new QName(XLINK_NS, "title"), new QName("title"));
        MAPPINGS.put(new QName(TEXT_NS, "a"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "a", hashMap));
        MAPPINGS.put(new QName(TABLE_NS, "table"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "table"));
        MAPPINGS.put(new QName(TABLE_NS, "table-row"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "tr"));
        HashMap<QName, QName> hashMap2 = new HashMap<QName, QName>();
        hashMap2.put(new QName(TABLE_NS, "number-columns-spanned"), new QName("colspan"));
        hashMap2.put(new QName(TABLE_NS, "number-rows-spanned"), new QName("rowspan"));
        hashMap2.put(new QName(TABLE_NS, "number-columns-repeated"), new QName("colspan"));
        MAPPINGS.put(new QName(TABLE_NS, "table-cell"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "td", hashMap2));
    }

    private static final class OpenDocumentElementMappingContentHandler
    extends ElementMappingContentHandler {
        private final ContentHandler handler;
        private final BitSet textNodeStack = new BitSet();
        private int nodeDepth = 0;
        private int completelyFiltered = 0;
        private Stack<String> headingStack = new Stack();
        private Map<String, TextStyle> textStyleMap = new HashMap<String, TextStyle>();
        private Map<String, ListStyle> listStyleMap = new HashMap<String, ListStyle>();
        private TextStyle textStyle;
        private TextStyle lastTextStyle;
        private Stack<ListStyle> listStyleStack = new Stack();
        private ListStyle listStyle;

        private OpenDocumentElementMappingContentHandler(ContentHandler contentHandler, Map<QName, ElementMappingContentHandler.TargetElement> map) {
            super(contentHandler, map);
            this.handler = contentHandler;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.completelyFiltered == 0 && this.nodeDepth > 0 && this.textNodeStack.get(this.nodeDepth - 1)) {
                this.lazyEndSpan();
                super.characters(cArray, n, n2);
            }
        }

        private boolean needsCompleteFiltering(String string, String string2) {
            if (OpenDocumentContentParser.TEXT_NS.equals(string)) {
                return string2.endsWith("-template") || string2.endsWith("-style");
            }
            return OpenDocumentContentParser.TABLE_NS.equals(string) && "covered-table-cell".equals(string2);
        }

        private String getXHTMLHeaderTagName(Attributes attributes) {
            String string = attributes.getValue(OpenDocumentContentParser.TEXT_NS, "outline-level");
            if (string == null) {
                return "h1";
            }
            int n = Integer.parseInt(string);
            if (n >= 6) {
                return "h6";
            }
            if (n <= 1) {
                return "h1";
            }
            return "h" + n;
        }

        private boolean isTextNode(String string, String string2) {
            if (OpenDocumentContentParser.TEXT_NS.equals(string) && !string2.equals("page-number") && !string2.equals("page-count")) {
                return true;
            }
            if (OpenDocumentContentParser.SVG_NS.equals(string)) {
                return "title".equals(string2) || "desc".equals(string2);
            }
            return false;
        }

        private void startList(String string) throws SAXException {
            String string2 = "ul";
            if (string != null) {
                ListStyle listStyle = this.listStyleMap.get(string);
                string2 = listStyle != null ? listStyle.getTag() : "ul";
                this.listStyleStack.push(listStyle);
            }
            this.handler.startElement("http://www.w3.org/1999/xhtml", string2, string2, EMPTY_ATTRIBUTES);
        }

        private void endList() throws SAXException {
            String string = "ul";
            if (!this.listStyleStack.isEmpty()) {
                ListStyle listStyle = this.listStyleStack.pop();
                string = listStyle != null ? listStyle.getTag() : "ul";
            }
            this.handler.endElement("http://www.w3.org/1999/xhtml", string, string);
        }

        private void startSpan(String string) throws SAXException {
            if (string == null) {
                return;
            }
            TextStyle textStyle = this.textStyleMap.get(string);
            if (textStyle == null) {
                return;
            }
            if (!textStyle.underlined && this.lastTextStyle != null && this.lastTextStyle.underlined) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "u", "u");
            }
            if (!textStyle.italic && this.lastTextStyle != null && this.lastTextStyle.italic) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "i", "i");
            }
            if (!textStyle.bold && this.lastTextStyle != null && this.lastTextStyle.bold) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "b", "b");
            }
            if (textStyle.bold && (this.lastTextStyle == null || !this.lastTextStyle.bold)) {
                this.handler.startElement("http://www.w3.org/1999/xhtml", "b", "b", EMPTY_ATTRIBUTES);
            }
            if (textStyle.italic && (this.lastTextStyle == null || !this.lastTextStyle.italic)) {
                this.handler.startElement("http://www.w3.org/1999/xhtml", "i", "i", EMPTY_ATTRIBUTES);
            }
            if (textStyle.underlined && (this.lastTextStyle == null || !this.lastTextStyle.underlined)) {
                this.handler.startElement("http://www.w3.org/1999/xhtml", "u", "u", EMPTY_ATTRIBUTES);
            }
            this.textStyle = textStyle;
            this.lastTextStyle = null;
        }

        private void endSpan() throws SAXException {
            this.lastTextStyle = this.textStyle;
            this.textStyle = null;
        }

        private void lazyEndSpan() throws SAXException {
            if (this.lastTextStyle == null) {
                return;
            }
            if (this.lastTextStyle.underlined) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "u", "u");
            }
            if (this.lastTextStyle.italic) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "i", "i");
            }
            if (this.lastTextStyle.bold) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "b", "b");
            }
            this.lastTextStyle = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            assert (this.nodeDepth >= 0);
            if (OpenDocumentContentParser.STYLE_NS.equals(string) && "style".equals(string2)) {
                string4 = attributes.getValue(OpenDocumentContentParser.STYLE_NS, "family");
                if ("text".equals(string4)) {
                    this.textStyle = new TextStyle();
                    String string5 = attributes.getValue(OpenDocumentContentParser.STYLE_NS, "name");
                    this.textStyleMap.put(string5, this.textStyle);
                }
            } else if (OpenDocumentContentParser.TEXT_NS.equals(string) && "list-style".equals(string2)) {
                this.listStyle = new ListStyle();
                string4 = attributes.getValue(OpenDocumentContentParser.STYLE_NS, "name");
                this.listStyleMap.put(string4, this.listStyle);
            } else if (this.textStyle != null && OpenDocumentContentParser.STYLE_NS.equals(string) && "text-properties".equals(string2)) {
                String string6;
                String string7;
                string4 = attributes.getValue(OpenDocumentContentParser.FORMATTING_OBJECTS_NS, "font-style");
                if ("italic".equals(string4) || "oblique".equals(string4)) {
                    this.textStyle.italic = true;
                }
                if ("bold".equals(string7 = attributes.getValue(OpenDocumentContentParser.FORMATTING_OBJECTS_NS, "font-weight")) || "bolder".equals(string7) || string7 != null && Character.isDigit(string7.charAt(0)) && Integer.valueOf(string7) > 500) {
                    this.textStyle.bold = true;
                }
                if ((string6 = attributes.getValue(OpenDocumentContentParser.STYLE_NS, "text-underline-style")) != null) {
                    this.textStyle.underlined = true;
                }
            } else if (this.listStyle != null && OpenDocumentContentParser.TEXT_NS.equals(string)) {
                if ("list-level-style-bullet".equals(string2)) {
                    this.listStyle.ordered = false;
                } else if ("list-level-style-number".equals(string2)) {
                    this.listStyle.ordered = true;
                }
            }
            this.textNodeStack.set(this.nodeDepth++, this.isTextNode(string, string2));
            assert (this.completelyFiltered >= 0);
            if (this.needsCompleteFiltering(string, string2)) {
                ++this.completelyFiltered;
            }
            if (this.completelyFiltered == 0) {
                if (OpenDocumentContentParser.TEXT_NS.equals(string) && "h".equals(string2)) {
                    string4 = this.headingStack.push(this.getXHTMLHeaderTagName(attributes));
                    this.handler.startElement("http://www.w3.org/1999/xhtml", string4, string4, EMPTY_ATTRIBUTES);
                } else if (OpenDocumentContentParser.TEXT_NS.equals(string) && "list".equals(string2)) {
                    this.startList(attributes.getValue(OpenDocumentContentParser.TEXT_NS, "style-name"));
                } else if (OpenDocumentContentParser.TEXT_NS.equals(string) && "span".equals(string2)) {
                    this.startSpan(attributes.getValue(OpenDocumentContentParser.TEXT_NS, "style-name"));
                } else {
                    super.startElement(string, string2, string3, attributes);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (OpenDocumentContentParser.STYLE_NS.equals(string) && "style".equals(string2)) {
                this.textStyle = null;
            } else if (OpenDocumentContentParser.TEXT_NS.equals(string) && "list-style".equals(string2)) {
                this.listStyle = null;
            }
            if (this.completelyFiltered == 0) {
                if (OpenDocumentContentParser.TEXT_NS.equals(string) && "h".equals(string2)) {
                    String string4 = this.headingStack.pop();
                    this.handler.endElement("http://www.w3.org/1999/xhtml", string4, string4);
                } else if (OpenDocumentContentParser.TEXT_NS.equals(string) && "list".equals(string2)) {
                    this.endList();
                } else if (OpenDocumentContentParser.TEXT_NS.equals(string) && "span".equals(string2)) {
                    this.endSpan();
                } else {
                    if (OpenDocumentContentParser.TEXT_NS.equals(string) && "p".equals(string2)) {
                        this.lazyEndSpan();
                    }
                    super.endElement(string, string2, string3);
                }
                if (OpenDocumentContentParser.TEXT_NS.equals(string) && ("tab-stop".equals(string2) || "tab".equals(string2))) {
                    this.characters(TAB, 0, TAB.length);
                }
            }
            if (this.needsCompleteFiltering(string, string2)) {
                --this.completelyFiltered;
            }
            assert (this.completelyFiltered >= 0);
            --this.nodeDepth;
            assert (this.nodeDepth >= 0);
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
        }

        @Override
        public void endPrefixMapping(String string) {
        }
    }

    private static class ListStyle
    implements Style {
        public boolean ordered;

        private ListStyle() {
        }

        public String getTag() {
            return this.ordered ? "ol" : "ul";
        }
    }

    private static class TextStyle
    implements Style {
        public boolean italic;
        public boolean bold;
        public boolean underlined;

        private TextStyle() {
        }
    }

    private static interface Style {
    }
}

