/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.odf.OpenDocumentContentParser;
import org.apache.tika.parser.odf.OpenDocumentMetaParser;
import org.apache.tika.sax.EndDocumentShieldingContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenDocumentParser
extends AbstractParser {
    private static final long serialVersionUID = -6410276875438618287L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("vnd.sun.xml.writer"), MediaType.application("vnd.oasis.opendocument.text"), MediaType.application("vnd.oasis.opendocument.graphics"), MediaType.application("vnd.oasis.opendocument.presentation"), MediaType.application("vnd.oasis.opendocument.spreadsheet"), MediaType.application("vnd.oasis.opendocument.chart"), MediaType.application("vnd.oasis.opendocument.image"), MediaType.application("vnd.oasis.opendocument.formula"), MediaType.application("vnd.oasis.opendocument.text-master"), MediaType.application("vnd.oasis.opendocument.text-web"), MediaType.application("vnd.oasis.opendocument.text-template"), MediaType.application("vnd.oasis.opendocument.graphics-template"), MediaType.application("vnd.oasis.opendocument.presentation-template"), MediaType.application("vnd.oasis.opendocument.spreadsheet-template"), MediaType.application("vnd.oasis.opendocument.chart-template"), MediaType.application("vnd.oasis.opendocument.image-template"), MediaType.application("vnd.oasis.opendocument.formula-template"), MediaType.application("x-vnd.oasis.opendocument.text"), MediaType.application("x-vnd.oasis.opendocument.graphics"), MediaType.application("x-vnd.oasis.opendocument.presentation"), MediaType.application("x-vnd.oasis.opendocument.spreadsheet"), MediaType.application("x-vnd.oasis.opendocument.chart"), MediaType.application("x-vnd.oasis.opendocument.image"), MediaType.application("x-vnd.oasis.opendocument.formula"), MediaType.application("x-vnd.oasis.opendocument.text-master"), MediaType.application("x-vnd.oasis.opendocument.text-web"), MediaType.application("x-vnd.oasis.opendocument.text-template"), MediaType.application("x-vnd.oasis.opendocument.graphics-template"), MediaType.application("x-vnd.oasis.opendocument.presentation-template"), MediaType.application("x-vnd.oasis.opendocument.spreadsheet-template"), MediaType.application("x-vnd.oasis.opendocument.chart-template"), MediaType.application("x-vnd.oasis.opendocument.image-template"), MediaType.application("x-vnd.oasis.opendocument.formula-template"))));
    private static final String META_NAME = "meta.xml";
    private Parser meta = new OpenDocumentMetaParser();
    private Parser content = new OpenDocumentContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser parser) {
        this.meta = parser;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser parser) {
        this.content = parser;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        Object object;
        Object object2;
        ZipFile zipFile = null;
        ZipInputStream zipInputStream = null;
        if (inputStream instanceof TikaInputStream) {
            object2 = (TikaInputStream)inputStream;
            object = ((TikaInputStream)inputStream).getOpenContainer();
            if (object instanceof ZipFile) {
                zipFile = (ZipFile)object;
            } else if (((TikaInputStream)object2).hasFile()) {
                zipFile = new ZipFile(((TikaInputStream)object2).getFile());
            } else {
                zipInputStream = new ZipInputStream(inputStream);
            }
        } else {
            zipInputStream = new ZipInputStream(inputStream);
        }
        object2 = new XHTMLContentHandler(contentHandler, metadata);
        object = new EndDocumentShieldingContentHandler((ContentHandler)object2);
        if (zipFile != null) {
            try {
                this.handleZipFile(zipFile, metadata, parseContext, (EndDocumentShieldingContentHandler)object);
            }
            finally {
                zipFile.close();
            }
        }
        try {
            this.handleZipStream(zipInputStream, metadata, parseContext, (EndDocumentShieldingContentHandler)object);
        }
        finally {
            zipInputStream.close();
        }
        if (((EndDocumentShieldingContentHandler)object).getEndDocumentWasCalled()) {
            ((EndDocumentShieldingContentHandler)object).reallyEndDocument();
        }
    }

    private void handleZipStream(ZipInputStream zipInputStream, Metadata metadata, ParseContext parseContext, EndDocumentShieldingContentHandler endDocumentShieldingContentHandler) throws IOException, TikaException, SAXException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            this.handleZipEntry(zipEntry, zipInputStream, metadata, parseContext, endDocumentShieldingContentHandler);
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    private void handleZipFile(ZipFile zipFile, Metadata metadata, ParseContext parseContext, EndDocumentShieldingContentHandler endDocumentShieldingContentHandler) throws IOException, TikaException, SAXException {
        ZipEntry zipEntry = zipFile.getEntry(META_NAME);
        if (zipEntry != null) {
            this.handleZipEntry(zipEntry, zipFile.getInputStream(zipEntry), metadata, parseContext, endDocumentShieldingContentHandler);
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (META_NAME.equals(zipEntry.getName())) continue;
            this.handleZipEntry(zipEntry, zipFile.getInputStream(zipEntry), metadata, parseContext, endDocumentShieldingContentHandler);
        }
    }

    private void handleZipEntry(ZipEntry zipEntry, InputStream inputStream, Metadata metadata, ParseContext parseContext, EndDocumentShieldingContentHandler endDocumentShieldingContentHandler) throws IOException, SAXException, TikaException {
        if (zipEntry == null) {
            return;
        }
        if (zipEntry.getName().equals("mimetype")) {
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            metadata.set("Content-Type", string);
        } else if (zipEntry.getName().equals(META_NAME)) {
            this.meta.parse(inputStream, new DefaultHandler(), metadata, parseContext);
        } else if (zipEntry.getName().endsWith("content.xml")) {
            if (this.content instanceof OpenDocumentContentParser) {
                ((OpenDocumentContentParser)this.content).parseInternal(inputStream, endDocumentShieldingContentHandler, metadata, parseContext);
            } else {
                this.content.parse(inputStream, endDocumentShieldingContentHandler, metadata, parseContext);
            }
        } else if (zipEntry.getName().endsWith("styles.xml")) {
            if (this.content instanceof OpenDocumentContentParser) {
                ((OpenDocumentContentParser)this.content).parseInternal(inputStream, endDocumentShieldingContentHandler, metadata, parseContext);
            } else {
                this.content.parse(inputStream, endDocumentShieldingContentHandler, metadata, parseContext);
            }
        }
    }
}

