/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.util.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.RTFMetadata;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.rtf.RTFParser;

class RTFObjDataParser {
    private static final int[] INT_LE_POWS = new int[]{1, 256, 65536, 0x1000000};
    private static final String WIN_ASCII = "WINDOWS-1252";

    RTFObjDataParser() {
    }

    protected byte[] parse(byte[] byArray, Metadata metadata, AtomicInteger atomicInteger) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        long l = this.readUInt(byteArrayInputStream);
        metadata.add(RTFMetadata.EMB_APP_VERSION, Long.toString(l));
        long l2 = this.readUInt(byteArrayInputStream);
        if (l2 != 2L) {
            return null;
        }
        String string = this.readLengthPrefixedAnsiString(byteArrayInputStream).trim();
        String string2 = this.readLengthPrefixedAnsiString(byteArrayInputStream).trim();
        String string3 = this.readLengthPrefixedAnsiString(byteArrayInputStream).trim();
        if (string != null && string.length() > 0) {
            metadata.add(RTFMetadata.EMB_CLASS, string);
        }
        if (string2 != null && string2.length() > 0) {
            metadata.add(RTFMetadata.EMB_TOPIC, string2);
        }
        if (string3 != null && string3.length() > 0) {
            metadata.add(RTFMetadata.EMB_ITEM, string3);
        }
        long l3 = this.readUInt(byteArrayInputStream);
        byte[] byArray2 = this.readBytes(byteArrayInputStream, l3);
        if (string.toLowerCase(Locale.ROOT).equals("package")) {
            return this.handlePackage(byArray2, metadata);
        }
        if (string.toLowerCase(Locale.ROOT).equals("pbrush")) {
            return byArray2;
        }
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
        if (NPOIFSFileSystem.hasPOIFSHeader((InputStream)byteArrayInputStream2)) {
            try {
                return this.handleEmbeddedPOIFS(byteArrayInputStream2, metadata, atomicInteger);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray2;
    }

    private byte[] handleEmbeddedPOIFS(InputStream inputStream, Metadata metadata, AtomicInteger atomicInteger) throws IOException {
        byte[] byArray;
        block19: {
            byArray = null;
            try (NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(inputStream);){
                DirectoryNode directoryNode = nPOIFSFileSystem.getRoot();
                if (directoryNode == null) {
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                if (directoryNode.hasEntry("Package")) {
                    Entry entry = directoryNode.getEntry("Package");
                    TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)new DocumentInputStream((DocumentEntry)entry));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)tikaInputStream, (OutputStream)byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                    break block19;
                }
                OfficeParser.POIFSDocumentType pOIFSDocumentType = OfficeParser.POIFSDocumentType.detectType((DirectoryEntry)directoryNode);
                if (pOIFSDocumentType == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                    try {
                        Ole10Native ole10Native = Ole10Native.createFromEmbeddedOleObject((DirectoryNode)directoryNode);
                        byArray = ole10Native.getDataBuffer();
                    }
                    catch (Ole10NativeException ole10NativeException) {}
                    break block19;
                }
                if (pOIFSDocumentType == OfficeParser.POIFSDocumentType.COMP_OBJ) {
                    DocumentEntry documentEntry;
                    try {
                        documentEntry = (DocumentEntry)directoryNode.getEntry("CONTENTS");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        documentEntry = (DocumentEntry)directoryNode.getEntry("Contents");
                    }
                    try (DocumentInputStream documentInputStream = new DocumentInputStream(documentEntry);){
                        byArray = new byte[documentEntry.getSize()];
                        documentInputStream.readFully(byArray);
                        break block19;
                    }
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                inputStream.reset();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
                metadata.set("resourceName", "file_" + atomicInteger.getAndIncrement() + "." + pOIFSDocumentType.getExtension());
                metadata.set("Content-Type", pOIFSDocumentType.getType().toString());
            }
        }
        return byArray;
    }

    private byte[] handlePackage(byte[] byArray, Metadata metadata) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.readUShort(byteArrayInputStream);
        String string = this.readAnsiString(byteArrayInputStream);
        this.readAnsiString(byteArrayInputStream);
        this.readUShort(byteArrayInputStream);
        int n = this.readUShort(byteArrayInputStream);
        if (n != 3) {
            return null;
        }
        this.readUInt(byteArrayInputStream);
        String string2 = this.readAnsiString(byteArrayInputStream);
        long l = this.readUInt(byteArrayInputStream);
        byte[] byArray2 = this.initByteArray(l);
        byteArrayInputStream.read(byArray2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            long l2 = this.readUInt(byteArrayInputStream);
            int n2 = 0;
            while ((long)n2 < l2) {
                int n3 = byteArrayInputStream.read();
                int n4 = byteArrayInputStream.read();
                int n5 = n3 + 256 * n4;
                if (n4 == -1 || n3 == -1) {
                    stringBuilder.setLength(0);
                    break;
                }
                stringBuilder.append((char)n5);
                ++n2;
            }
        }
        catch (IOException iOException) {
            stringBuilder.setLength(0);
        }
        String string3 = "";
        String string4 = "";
        if (stringBuilder.length() > 0) {
            String string5;
            string3 = string5 = stringBuilder.toString();
            string4 = string5;
        } else {
            string3 = string == null ? "" : string;
            string4 = string2 == null ? "" : string2;
        }
        metadata.set("resourceName", FilenameUtils.getName((String)string3));
        metadata.set("embeddedRelationshipId", string4);
        return byArray2;
    }

    private int readUShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read() * 256;
        if (n == -1 || n2 == -1) {
            throw new IOException("Hit end of stream before reading little endian unsigned short.");
        }
        return n2 + n;
    }

    private long readUInt(InputStream inputStream) throws IOException {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            int n = inputStream.read();
            if (n == -1) {
                throw new IOException("Hit end of stream before finishing little endian unsigned int.");
            }
            l += (long)n * (long)INT_LE_POWS[i];
        }
        return l;
    }

    private String readAnsiString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = inputStream.read();
        while (n > 0) {
            stringBuilder.append((char)n);
            n = inputStream.read();
        }
        if (n == -1) {
            throw new IOException("Hit end of stream before end of AnsiString");
        }
        return stringBuilder.toString();
    }

    private String readLengthPrefixedAnsiString(InputStream inputStream) throws IOException {
        long l = this.readUInt(inputStream);
        byte[] byArray = this.readBytes(inputStream, l);
        try {
            return new String(byArray, WIN_ASCII);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("Unsupported encoding");
        }
    }

    private byte[] readBytes(InputStream inputStream, long l) throws IOException {
        byte[] byArray = this.initByteArray(l);
        int n = inputStream.read(byArray);
        if ((long)n != l) {
            throw new IOException("Hit end of stream before reading all bytes");
        }
        return byArray;
    }

    private byte[] initByteArray(long l) throws IOException {
        if (l < 0L || l > (long)RTFParser.getMaxBytesForEmbeddedObject()) {
            throw new IOException("Requested length for reading bytes is out of bounds: " + l);
        }
        return new byte[(int)l];
    }
}

