/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.xml.AbstractMetadataHandler;
import org.xml.sax.Attributes;

public class ElementMetadataHandler
extends AbstractMetadataHandler {
    private static final Log logger = LogFactory.getLog(ElementMetadataHandler.class);
    private static final String LOCAL_NAME_RDF_BAG = "Bag";
    private static final String LOCAL_NAME_RDF_LI = "li";
    private static final String URI_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private final String uri;
    private final String localName;
    private final Metadata metadata;
    private final String name;
    private Property targetProperty;
    private final boolean allowDuplicateValues;
    private final boolean allowEmptyValues;
    private final StringBuilder bufferBagged = new StringBuilder();
    private final StringBuilder bufferBagless = new StringBuilder();
    private boolean isBagless = true;
    private int matchLevel = 0;
    private int parentMatchLevel = 0;

    public ElementMetadataHandler(String string, String string2, Metadata metadata, String string3) {
        super(metadata, string3);
        this.uri = string;
        this.localName = string2;
        this.metadata = metadata;
        this.name = string3;
        this.allowDuplicateValues = false;
        this.allowEmptyValues = false;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created simple handler for " + this.name));
        }
    }

    public ElementMetadataHandler(String string, String string2, Metadata metadata, String string3, boolean bl, boolean bl2) {
        super(metadata, string3);
        this.uri = string;
        this.localName = string2;
        this.metadata = metadata;
        this.name = string3;
        this.allowDuplicateValues = bl;
        this.allowEmptyValues = bl2;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created simple handler for " + this.name));
        }
    }

    public ElementMetadataHandler(String string, String string2, Metadata metadata, Property property) {
        super(metadata, property);
        this.uri = string;
        this.localName = string2;
        this.metadata = metadata;
        this.targetProperty = property;
        this.name = property.getName();
        this.allowDuplicateValues = false;
        this.allowEmptyValues = false;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created property handler for " + this.name));
        }
    }

    public ElementMetadataHandler(String string, String string2, Metadata metadata, Property property, boolean bl, boolean bl2) {
        super(metadata, property);
        this.uri = string;
        this.localName = string2;
        this.metadata = metadata;
        this.targetProperty = property;
        this.name = property.getName();
        this.allowDuplicateValues = bl;
        this.allowEmptyValues = bl2;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created property handler for " + this.name));
        }
    }

    protected boolean isMatchingParentElement(String string, String string2) {
        return string.equals(this.uri) && string2.equals(this.localName);
    }

    protected boolean isMatchingElement(String string, String string2) {
        return string.equals(this.uri) && string2.equals(this.localName) || this.parentMatchLevel > 0 && (string.equals(URI_RDF) && string2.equals(LOCAL_NAME_RDF_BAG) || string.equals(URI_RDF) && string2.equals(LOCAL_NAME_RDF_LI));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.isMatchingElement(string, string2)) {
            ++this.matchLevel;
        }
        if (this.isMatchingParentElement(string, string2)) {
            ++this.parentMatchLevel;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.isMatchingParentElement(string, string2)) {
            --this.parentMatchLevel;
        }
        if (this.isMatchingElement(string, string2)) {
            --this.matchLevel;
            if (this.matchLevel == 2) {
                this.addMetadata(this.bufferBagged.toString().trim());
                this.bufferBagged.setLength(0);
                this.isBagless = false;
            }
            if (this.matchLevel == 0 && this.isBagless) {
                String string4 = this.bufferBagless.toString();
                if (string4.length() > 0 && !string4.contains(LOCAL_NAME_RDF_BAG)) {
                    this.addMetadata(string4.trim());
                    this.bufferBagless.setLength(0);
                }
                this.isBagless = true;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.parentMatchLevel > 0 && this.matchLevel > 2) {
            this.bufferBagged.append(cArray, n, n2);
        }
        if (this.parentMatchLevel > 0 && this.matchLevel > 0) {
            this.bufferBagless.append(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    @Override
    protected void addMetadata(String string) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("adding " + this.name + "=" + string));
        }
        if (this.targetProperty != null && this.targetProperty.isMultiValuePermitted()) {
            if (string != null && string.length() > 0 || this.allowEmptyValues) {
                String[] stringArray;
                if (string == null || string.length() == 0 && this.allowEmptyValues) {
                    string = "";
                }
                if ((stringArray = this.metadata.getValues(this.name)) == null || !Arrays.asList(stringArray).contains(string) || this.allowDuplicateValues) {
                    this.metadata.add(this.targetProperty, string);
                }
            }
        } else {
            super.addMetadata(string);
        }
    }
}

