/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xml.XMLParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FictionBookParser
extends XMLParser {
    private static final long serialVersionUID = 4195954546491524374L;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return Collections.singleton(MediaType.application("x-fictionbook+xml"));
    }

    @Override
    protected ContentHandler getContentHandler(ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
        EmbeddedDocumentExtractor embeddedDocumentExtractor = parseContext.get(EmbeddedDocumentExtractor.class);
        if (embeddedDocumentExtractor == null) {
            embeddedDocumentExtractor = new ParsingEmbeddedDocumentExtractor(parseContext);
        }
        return new BinaryElementsDataHandler(embeddedDocumentExtractor, contentHandler);
    }

    private static class BinaryElementsDataHandler
    extends DefaultHandler {
        private static final String ELEMENT_BINARY = "binary";
        private boolean binaryMode = false;
        private static final String ATTRIBUTE_ID = "id";
        private final EmbeddedDocumentExtractor partExtractor;
        private final ContentHandler handler;
        private final StringBuilder binaryData = new StringBuilder();
        private Metadata metadata;
        private static final String ATTRIBUTE_CONTENT_TYPE = "content-type";

        private BinaryElementsDataHandler(EmbeddedDocumentExtractor embeddedDocumentExtractor, ContentHandler contentHandler) {
            this.partExtractor = embeddedDocumentExtractor;
            this.handler = contentHandler;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.binaryMode = ELEMENT_BINARY.equals(string2);
            if (this.binaryMode) {
                this.binaryData.setLength(0);
                this.metadata = new Metadata();
                this.metadata.set("resourceName", attributes.getValue(ATTRIBUTE_ID));
                this.metadata.set("Content-Type", attributes.getValue(ATTRIBUTE_CONTENT_TYPE));
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.binaryMode) {
                try {
                    this.partExtractor.parseEmbedded(new ByteArrayInputStream(Base64.decodeBase64((String)this.binaryData.toString())), this.handler, this.metadata, true);
                }
                catch (IOException iOException) {
                    throw new SAXException("IOException in parseEmbedded", iOException);
                }
                this.binaryMode = false;
                this.binaryData.setLength(0);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!this.binaryMode) {
                this.handler.characters(cArray, n, n2);
            } else {
                this.binaryData.append(cArray, n, n2);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.handler.ignorableWhitespace(cArray, n, n2);
        }
    }
}

