/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.TaggedContentHandler;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends AbstractParser {
    private static final long serialVersionUID = -6028836725280212837L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("xml"), MediaType.image("svg+xml"))));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        if (metadata.get("Content-Type") == null) {
            metadata.set("Content-Type", "application/xml");
        }
        XHTMLContentHandler xHTMLContentHandler = new XHTMLContentHandler(contentHandler, metadata);
        xHTMLContentHandler.startDocument();
        xHTMLContentHandler.startElement("p");
        TaggedContentHandler taggedContentHandler = new TaggedContentHandler(contentHandler);
        try {
            parseContext.getSAXParser().parse((InputStream)new CloseShieldInputStream(inputStream), (DefaultHandler)new OfflineContentHandler(new EmbeddedContentHandler(this.getContentHandler(taggedContentHandler, metadata, parseContext))));
        }
        catch (SAXException sAXException) {
            taggedContentHandler.throwIfCauseOf(sAXException);
            throw new TikaException("XML parse error", sAXException);
        }
        finally {
            xHTMLContentHandler.endElement("p");
            xHTMLContentHandler.endDocument();
        }
    }

    protected ContentHandler getContentHandler(ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
        return new TextContentHandler(contentHandler, true);
    }
}

