/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.sax.ToHTMLContentHandler;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.sax.ToXMLContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class BasicContentHandlerFactory
implements ContentHandlerFactory {
    private final HANDLER_TYPE type;
    private final int writeLimit;

    public static HANDLER_TYPE parseHandlerType(String string, HANDLER_TYPE hANDLER_TYPE) {
        String string2;
        if (string == null) {
            return hANDLER_TYPE;
        }
        switch (string2 = string.toLowerCase(Locale.ROOT)) {
            case "xml": {
                return HANDLER_TYPE.XML;
            }
            case "text": {
                return HANDLER_TYPE.TEXT;
            }
            case "txt": {
                return HANDLER_TYPE.TEXT;
            }
            case "html": {
                return HANDLER_TYPE.HTML;
            }
            case "body": {
                return HANDLER_TYPE.BODY;
            }
            case "ignore": {
                return HANDLER_TYPE.IGNORE;
            }
        }
        return hANDLER_TYPE;
    }

    public BasicContentHandlerFactory(HANDLER_TYPE hANDLER_TYPE, int n) {
        this.type = hANDLER_TYPE;
        this.writeLimit = n;
    }

    @Override
    public ContentHandler getNewContentHandler() {
        if (this.type == HANDLER_TYPE.BODY) {
            return new BodyContentHandler(this.writeLimit);
        }
        if (this.type == HANDLER_TYPE.IGNORE) {
            return new DefaultHandler();
        }
        if (this.writeLimit > -1) {
            switch (this.type) {
                case TEXT: {
                    return new WriteOutContentHandler(new ToTextContentHandler(), this.writeLimit);
                }
                case HTML: {
                    return new WriteOutContentHandler(new ToHTMLContentHandler(), this.writeLimit);
                }
                case XML: {
                    return new WriteOutContentHandler(new ToXMLContentHandler(), this.writeLimit);
                }
            }
            return new WriteOutContentHandler(new ToTextContentHandler(), this.writeLimit);
        }
        switch (this.type) {
            case TEXT: {
                return new ToTextContentHandler();
            }
            case HTML: {
                return new ToHTMLContentHandler();
            }
            case XML: {
                return new ToXMLContentHandler();
            }
        }
        return new ToTextContentHandler();
    }

    @Override
    public ContentHandler getNewContentHandler(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (this.type == HANDLER_TYPE.IGNORE) {
            return new DefaultHandler();
        }
        if (this.writeLimit > -1) {
            switch (this.type) {
                case BODY: {
                    return new WriteOutContentHandler(new BodyContentHandler(new OutputStreamWriter(outputStream, string)), this.writeLimit);
                }
                case TEXT: {
                    return new WriteOutContentHandler(new ToTextContentHandler(outputStream, string), this.writeLimit);
                }
                case HTML: {
                    return new WriteOutContentHandler(new ToHTMLContentHandler(outputStream, string), this.writeLimit);
                }
                case XML: {
                    return new WriteOutContentHandler(new ToXMLContentHandler(outputStream, string), this.writeLimit);
                }
            }
            return new WriteOutContentHandler(new ToTextContentHandler(outputStream, string), this.writeLimit);
        }
        switch (this.type) {
            case BODY: {
                return new BodyContentHandler(new OutputStreamWriter(outputStream, string));
            }
            case TEXT: {
                return new ToTextContentHandler(outputStream, string);
            }
            case HTML: {
                return new ToHTMLContentHandler(outputStream, string);
            }
            case XML: {
                return new ToXMLContentHandler(outputStream, string);
            }
        }
        return new ToTextContentHandler(outputStream, string);
    }

    public HANDLER_TYPE getType() {
        return this.type;
    }

    public static enum HANDLER_TYPE {
        BODY,
        IGNORE,
        TEXT,
        HTML,
        XML;

    }
}

