/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.Stack;
import org.apache.tika.metadata.Metadata;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DIFContentHandler
extends DefaultHandler {
    private static final char[] NEWLINE = new char[]{'\n'};
    private static final char[] TABSPACE = new char[]{'\t'};
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private Stack<String> treeStack;
    private Stack<String> dataStack;
    private final ContentHandler delegate;
    private boolean isLeaf;
    private Metadata metadata;

    public DIFContentHandler(ContentHandler contentHandler, Metadata metadata) {
        this.delegate = contentHandler;
        this.isLeaf = false;
        this.metadata = metadata;
        this.treeStack = new Stack();
        this.dataStack = new Stack();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.delegate.setDocumentLocator(locator);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object object;
        String string = new String(cArray, n, n2).toString();
        this.dataStack.push(string);
        if (this.treeStack.peek().equals("Entry_Title")) {
            this.delegate.characters(NEWLINE, 0, NEWLINE.length);
            this.delegate.characters(TABSPACE, 0, TABSPACE.length);
            this.delegate.startElement("", "h3", "h3", EMPTY_ATTRIBUTES);
            object = "Title: ";
            object = (String)object + string;
            this.delegate.characters(((String)object).toCharArray(), 0, ((String)object).length());
            this.delegate.endElement("", "h3", "h3");
        }
        if (this.treeStack.peek().equals("Southernmost_Latitude") || this.treeStack.peek().equals("Northernmost_Latitude") || this.treeStack.peek().equals("Westernmost_Longitude") || this.treeStack.peek().equals("Easternmost_Longitude")) {
            this.delegate.characters(NEWLINE, 0, NEWLINE.length);
            this.delegate.characters(TABSPACE, 0, TABSPACE.length);
            this.delegate.characters(TABSPACE, 0, TABSPACE.length);
            this.delegate.startElement("", "tr", "tr", EMPTY_ATTRIBUTES);
            this.delegate.startElement("", "td", "td", EMPTY_ATTRIBUTES);
            object = this.treeStack.peek() + " : ";
            this.delegate.characters(((String)object).toCharArray(), 0, ((String)object).length());
            this.delegate.endElement("", "td", "td");
            this.delegate.startElement("", "td", "td", EMPTY_ATTRIBUTES);
            this.delegate.characters(string.toCharArray(), 0, string.length());
            this.delegate.endElement("", "td", "td");
            this.delegate.endElement("", "tr", "tr");
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.delegate.ignorableWhitespace(cArray, n, n2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.isLeaf = true;
        if (string2.equals("Spatial_Coverage")) {
            this.delegate.characters(NEWLINE, 0, NEWLINE.length);
            this.delegate.characters(TABSPACE, 0, TABSPACE.length);
            this.delegate.startElement("", "h3", "h3", EMPTY_ATTRIBUTES);
            String string4 = "Geographic Data: ";
            this.delegate.characters(string4.toCharArray(), 0, string4.length());
            this.delegate.endElement("", "h3", "h3");
            this.delegate.characters(NEWLINE, 0, NEWLINE.length);
            this.delegate.characters(TABSPACE, 0, TABSPACE.length);
            this.delegate.startElement("", "table", "table", EMPTY_ATTRIBUTES);
        }
        this.treeStack.push(string2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("Spatial_Coverage")) {
            this.delegate.characters(NEWLINE, 0, NEWLINE.length);
            this.delegate.characters(TABSPACE, 0, TABSPACE.length);
            this.delegate.endElement("", "table", "table");
        }
        if (this.isLeaf) {
            Stack stack = (Stack)this.treeStack.clone();
            Object object = "";
            while (!stack.isEmpty()) {
                if (((String)object).length() == 0) {
                    object = (String)stack.pop();
                    continue;
                }
                object = (String)stack.pop() + "-" + (String)object;
            }
            String string4 = this.dataStack.peek();
            this.metadata.add((String)object, string4);
            this.isLeaf = false;
        }
        this.treeStack.pop();
        this.dataStack.pop();
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

