/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExpandedTitleContentHandler
extends ContentHandlerDecorator {
    private boolean isTitleTagOpen;
    private static final String TITLE_TAG = "TITLE";

    public ExpandedTitleContentHandler() {
    }

    public ExpandedTitleContentHandler(ContentHandler contentHandler) {
        super(contentHandler);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.isTitleTagOpen = false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (TITLE_TAG.equalsIgnoreCase(string2) && "http://www.w3.org/1999/xhtml".equals(string)) {
            this.isTitleTagOpen = true;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (TITLE_TAG.equalsIgnoreCase(string2) && "http://www.w3.org/1999/xhtml".equals(string)) {
            this.isTitleTagOpen = false;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isTitleTagOpen && n2 == 0) {
            try {
                super.characters(new char[0], 0, 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else {
            super.characters(cArray, n, n2);
        }
    }
}

