/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tika.sax.Link;
import org.apache.tika.sax.LinkBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class LinkContentHandler
extends DefaultHandler {
    private final LinkedList<LinkBuilder> builderStack = new LinkedList();
    private final List<Link> links = new ArrayList<Link>();
    private boolean collapseWhitespaceInAnchor;

    public LinkContentHandler() {
        this(false);
    }

    public LinkContentHandler(boolean bl) {
        this.collapseWhitespaceInAnchor = bl;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("http://www.w3.org/1999/xhtml".equals(string)) {
            if ("a".equals(string2)) {
                LinkBuilder linkBuilder = new LinkBuilder("a");
                linkBuilder.setURI(attributes.getValue("", "href"));
                linkBuilder.setTitle(attributes.getValue("", "title"));
                linkBuilder.setRel(attributes.getValue("", "rel"));
                this.builderStack.addFirst(linkBuilder);
            } else if ("link".equals(string2)) {
                LinkBuilder linkBuilder = new LinkBuilder("link");
                linkBuilder.setURI(attributes.getValue("", "href"));
                linkBuilder.setRel(attributes.getValue("", "rel"));
                this.builderStack.addFirst(linkBuilder);
            } else if ("script".equals(string2)) {
                if (attributes.getValue("", "src") != null) {
                    LinkBuilder linkBuilder = new LinkBuilder("script");
                    linkBuilder.setURI(attributes.getValue("", "src"));
                    this.builderStack.addFirst(linkBuilder);
                }
            } else if ("iframe".equals(string2)) {
                LinkBuilder linkBuilder = new LinkBuilder("iframe");
                linkBuilder.setURI(attributes.getValue("", "src"));
                this.builderStack.addFirst(linkBuilder);
            } else if ("img".equals(string2)) {
                LinkBuilder linkBuilder = new LinkBuilder("img");
                linkBuilder.setURI(attributes.getValue("", "src"));
                linkBuilder.setTitle(attributes.getValue("", "title"));
                linkBuilder.setRel(attributes.getValue("", "rel"));
                this.builderStack.addFirst(linkBuilder);
                String string4 = attributes.getValue("", "alt");
                if (string4 != null) {
                    char[] cArray = string4.toCharArray();
                    this.characters(cArray, 0, cArray.length);
                }
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        for (LinkBuilder linkBuilder : this.builderStack) {
            linkBuilder.characters(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (!this.builderStack.isEmpty() && "http://www.w3.org/1999/xhtml".equals(string) && ("a".equals(string2) || "img".equals(string2) || "link".equals(string2) || "script".equals(string2) || "iframe".equals(string2)) && this.builderStack.getFirst().getType().equals(string2)) {
            LinkBuilder linkBuilder = this.builderStack.removeFirst();
            this.links.add(linkBuilder.getLink(this.collapseWhitespaceInAnchor));
        }
    }
}

