/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.CleanPhoneText;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PhoneExtractingContentHandler
extends ContentHandlerDecorator {
    private Metadata metadata;
    private static final String PHONE_NUMBERS = "phonenumbers";
    private StringBuilder stringBuilder;

    public PhoneExtractingContentHandler(ContentHandler contentHandler, Metadata metadata) {
        super(contentHandler);
        this.metadata = metadata;
        this.stringBuilder = new StringBuilder();
    }

    protected PhoneExtractingContentHandler() {
        this(new DefaultHandler(), new Metadata());
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            String string = new String(Arrays.copyOfRange(cArray, n, n + n2));
            this.stringBuilder.append(string);
            super.characters(cArray, n, n2);
        }
        catch (SAXException sAXException) {
            this.handleException(sAXException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        ArrayList<String> arrayList = CleanPhoneText.extractPhoneNumbers(this.stringBuilder.toString());
        for (String string : arrayList) {
            this.metadata.add(PHONE_NUMBERS, string);
        }
    }
}

