/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SafeContentHandler
extends ContentHandlerDecorator {
    private static final char[] REPLACEMENT = new char[]{'\ufffd'};
    private final Output charactersOutput = new Output(){

        @Override
        public void write(char[] cArray, int n, int n2) throws SAXException {
            SafeContentHandler.super.characters(cArray, n, n2);
        }
    };
    private final Output ignorableWhitespaceOutput = new Output(){

        @Override
        public void write(char[] cArray, int n, int n2) throws SAXException {
            SafeContentHandler.super.ignorableWhitespace(cArray, n, n2);
        }
    };

    public SafeContentHandler(ContentHandler contentHandler) {
        super(contentHandler);
    }

    private void filter(char[] cArray, int n, int n2, Output output) throws SAXException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = Character.codePointAt(cArray, n4, n3);
            int n6 = n4 + Character.charCount(n5);
            if (this.isInvalid(n5)) {
                if (n4 > n) {
                    output.write(cArray, n, n4 - n);
                }
                this.writeReplacement(output);
                n = n6;
            }
            n4 = n6;
        }
        output.write(cArray, n, n3 - n);
    }

    private boolean isInvalid(String string) {
        int n;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; i += Character.charCount(n)) {
            n = Character.codePointAt(cArray, i);
            if (!this.isInvalid(n)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInvalid(int n) {
        if (n < 32) {
            return n != 9 && n != 10 && n != 13;
        }
        if (n < 57344) {
            return n > 55295;
        }
        if (n < 65536) {
            return n > 65533;
        }
        return n > 0x10FFFF;
    }

    protected void writeReplacement(Output output) throws SAXException {
        output.write(REPLACEMENT, 0, REPLACEMENT.length);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!this.isInvalid(attributes.getValue(i))) continue;
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int j = 0; j < attributes.getLength(); ++j) {
                String string4 = attributes.getValue(j);
                if (j >= i && this.isInvalid(string4)) {
                    StringOutput stringOutput = new StringOutput();
                    this.filter(string4.toCharArray(), 0, string4.length(), stringOutput);
                    string4 = ((Object)stringOutput).toString();
                }
                attributesImpl.addAttribute(attributes.getURI(j), attributes.getLocalName(j), attributes.getQName(j), attributes.getType(j), string4);
            }
            attributes = attributesImpl;
            break;
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.filter(cArray, n, n2, this.charactersOutput);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.filter(cArray, n, n2, this.ignorableWhitespaceOutput);
    }

    protected static interface Output {
        public void write(char[] var1, int var2, int var3) throws SAXException;
    }

    private static class StringOutput
    implements Output {
        private final StringBuilder builder = new StringBuilder();

        private StringOutput() {
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            this.builder.append(cArray, n, n2);
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

