/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SecureContentHandler
extends ContentHandlerDecorator {
    private final TikaInputStream stream;
    private long characterCount = 0L;
    private int currentDepth = 0;
    private LinkedList<Integer> packageEntryDepths = new LinkedList();
    private long threshold = 1000000L;
    private long ratio = 100L;
    private int maxDepth = 100;
    private int maxPackageEntryDepth = 10;

    public SecureContentHandler(ContentHandler contentHandler, TikaInputStream tikaInputStream) {
        super(contentHandler);
        this.stream = tikaInputStream;
    }

    public long getOutputThreshold() {
        return this.threshold;
    }

    public void setOutputThreshold(long l) {
        this.threshold = l;
    }

    public long getMaximumCompressionRatio() {
        return this.ratio;
    }

    public void setMaximumCompressionRatio(long l) {
        this.ratio = l;
    }

    public int getMaximumDepth() {
        return this.maxDepth;
    }

    public void setMaximumPackageEntryDepth(int n) {
        this.maxPackageEntryDepth = n;
    }

    public int getMaximumPackageEntryDepth() {
        return this.maxPackageEntryDepth;
    }

    public void setMaximumDepth(int n) {
        this.maxDepth = n;
    }

    public void throwIfCauseOf(SAXException sAXException) throws TikaException {
        if (sAXException instanceof SecureSAXException && ((SecureSAXException)sAXException).isCausedBy(this)) {
            throw new TikaException("Zip bomb detected!", sAXException);
        }
    }

    private long getByteCount() throws SAXException {
        try {
            if (this.stream.hasLength()) {
                return this.stream.getLength();
            }
            return this.stream.getPosition();
        }
        catch (IOException iOException) {
            throw new SAXException("Unable to get stream length", iOException);
        }
    }

    private void advance(int n) throws SAXException {
        this.characterCount += (long)n;
        long l = this.getByteCount();
        if (this.characterCount > this.threshold && this.characterCount > l * this.ratio) {
            throw new SecureSAXException("Suspected zip bomb: " + l + " input bytes produced " + this.characterCount + " output characters");
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.currentDepth;
        if (this.currentDepth >= this.maxDepth) {
            throw new SecureSAXException("Suspected zip bomb: " + this.currentDepth + " levels of XML element nesting");
        }
        if ("div".equals(string3) && "package-entry".equals(attributes.getValue("class"))) {
            this.packageEntryDepths.addLast(this.currentDepth);
            if (this.packageEntryDepths.size() >= this.maxPackageEntryDepth) {
                throw new SecureSAXException("Suspected zip bomb: " + this.packageEntryDepths.size() + " levels of package entry nesting");
            }
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (!this.packageEntryDepths.isEmpty() && this.packageEntryDepths.getLast() == this.currentDepth) {
            this.packageEntryDepths.removeLast();
        }
        --this.currentDepth;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.advance(n2);
        super.characters(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.advance(n2);
        super.ignorableWhitespace(cArray, n, n2);
    }

    private class SecureSAXException
    extends SAXException {
        private static final long serialVersionUID = 2285245380321771445L;

        public SecureSAXException(String string) throws SAXException {
            super(string);
        }

        public boolean isCausedBy(SecureContentHandler secureContentHandler) {
            return SecureContentHandler.this == secureContentHandler;
        }
    }
}

