/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax.xpath;

import java.util.LinkedList;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.xpath.CompositeMatcher;
import org.apache.tika.sax.xpath.ElementMatcher;
import org.apache.tika.sax.xpath.Matcher;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MatchingContentHandler
extends ContentHandlerDecorator {
    private final LinkedList<Matcher> matchers = new LinkedList();
    private Matcher matcher;

    public MatchingContentHandler(ContentHandler contentHandler, Matcher matcher) {
        super(contentHandler);
        this.matcher = matcher;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.matchers.addFirst(this.matcher);
        this.matcher = this.matcher.descend(string, string2);
        AttributesImpl attributesImpl = new AttributesImpl();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4;
            String string5 = attributes.getURI(i);
            if (!this.matcher.matchesAttribute(string5, string4 = attributes.getLocalName(i))) continue;
            attributesImpl.addAttribute(string5, string4, attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        if (this.matcher.matchesElement() || attributesImpl.getLength() > 0) {
            super.startElement(string, string2, string3, attributesImpl);
            if (!this.matcher.matchesElement()) {
                this.matcher = new CompositeMatcher(this.matcher, ElementMatcher.INSTANCE);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.matcher.matchesElement()) {
            super.endElement(string, string2, string3);
        }
        if (!this.matchers.isEmpty()) {
            this.matcher = this.matchers.removeFirst();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.matcher.matchesText()) {
            super.characters(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.matcher.matchesText()) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (this.matcher.matchesText()) {
            super.skippedEntity(string);
        }
    }
}

