/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax.xpath;

import java.util.HashMap;
import java.util.Map;
import org.apache.tika.sax.xpath.AttributeMatcher;
import org.apache.tika.sax.xpath.ChildMatcher;
import org.apache.tika.sax.xpath.CompositeMatcher;
import org.apache.tika.sax.xpath.ElementMatcher;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.NamedAttributeMatcher;
import org.apache.tika.sax.xpath.NamedElementMatcher;
import org.apache.tika.sax.xpath.NodeMatcher;
import org.apache.tika.sax.xpath.SubtreeMatcher;
import org.apache.tika.sax.xpath.TextMatcher;

public class XPathParser {
    private final Map<String, String> prefixes = new HashMap<String, String>();

    public XPathParser() {
    }

    public XPathParser(String string, String string2) {
        this.addPrefix(string, string2);
    }

    public void addPrefix(String string, String string2) {
        this.prefixes.put(string, string2);
    }

    public Matcher parse(String string) {
        if (string.equals("/text()")) {
            return TextMatcher.INSTANCE;
        }
        if (string.equals("/node()")) {
            return NodeMatcher.INSTANCE;
        }
        if (string.equals("/descendant::node()") || string.equals("/descendant:node()")) {
            return new CompositeMatcher(TextMatcher.INSTANCE, new ChildMatcher(new SubtreeMatcher(NodeMatcher.INSTANCE)));
        }
        if (string.equals("/@*")) {
            return AttributeMatcher.INSTANCE;
        }
        if (string.length() == 0) {
            return ElementMatcher.INSTANCE;
        }
        if (string.startsWith("/@")) {
            String string2 = string.substring(2);
            String string3 = null;
            int n = string2.indexOf(58);
            if (n != -1) {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            if (this.prefixes.containsKey(string3)) {
                return new NamedAttributeMatcher(this.prefixes.get(string3), string2);
            }
            return Matcher.FAIL;
        }
        if (string.startsWith("/*")) {
            return new ChildMatcher(this.parse(string.substring(2)));
        }
        if (string.startsWith("///")) {
            return Matcher.FAIL;
        }
        if (string.startsWith("//")) {
            return new SubtreeMatcher(this.parse(string.substring(1)));
        }
        if (string.startsWith("/")) {
            int n = string.indexOf(47, 1);
            if (n == -1) {
                n = string.length();
            }
            String string4 = string.substring(1, n);
            String string5 = null;
            int n2 = string4.indexOf(58);
            if (n2 != -1) {
                string5 = string4.substring(0, n2);
                string4 = string4.substring(n2 + 1);
            }
            if (this.prefixes.containsKey(string5)) {
                return new NamedElementMatcher(this.prefixes.get(string5), string4, this.parse(string.substring(n)));
            }
            return Matcher.FAIL;
        }
        return Matcher.FAIL;
    }
}

