/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharsetUtils {
    private static final Pattern CHARSET_NAME_PATTERN = Pattern.compile("[ \\\"]*([^ >,;\\\"]+).*");
    private static final Pattern ISO_NAME_PATTERN = Pattern.compile(".*8859-(\\d+)");
    private static final Pattern CP_NAME_PATTERN = Pattern.compile("cp-(\\d+)");
    private static final Pattern WIN_NAME_PATTERN = Pattern.compile("win-?(\\d+)");
    private static final Map<String, Charset> COMMON_CHARSETS = new HashMap<String, Charset>();
    private static Method getCharsetICU = null;
    private static Method isSupportedICU = null;

    private static Map<String, Charset> initCommonCharsets(String ... stringArray) {
        HashMap<String, Charset> hashMap = new HashMap<String, Charset>();
        for (String string : stringArray) {
            try {
                Charset charset = Charset.forName(string);
                COMMON_CHARSETS.put(string.toLowerCase(Locale.ENGLISH), charset);
                for (String string2 : charset.aliases()) {
                    COMMON_CHARSETS.put(string2.toLowerCase(Locale.ENGLISH), charset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public static boolean isSupported(String string) {
        try {
            if (isSupportedICU != null && ((Boolean)isSupportedICU.invoke(null, string)).booleanValue()) {
                return true;
            }
            return Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String clean(String string) {
        try {
            return CharsetUtils.forName(string).name();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Charset forName(String object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Matcher matcher = CHARSET_NAME_PATTERN.matcher((CharSequence)object);
        if (!matcher.matches()) {
            throw new IllegalCharsetNameException((String)object);
        }
        object = matcher.group(1);
        String string = ((String)object).toLowerCase(Locale.ENGLISH);
        Charset charset = COMMON_CHARSETS.get(string);
        if (charset != null) {
            return charset;
        }
        if ("none".equals(string) || "no".equals(string)) {
            throw new IllegalCharsetNameException((String)object);
        }
        Object object2 = ISO_NAME_PATTERN.matcher(string);
        Matcher matcher2 = CP_NAME_PATTERN.matcher(string);
        Matcher matcher3 = WIN_NAME_PATTERN.matcher(string);
        if (((Matcher)object2).matches()) {
            object = "iso-8859-" + ((Matcher)object2).group(1);
            charset = COMMON_CHARSETS.get(object);
        } else if (matcher2.matches()) {
            object = "cp" + matcher2.group(1);
            charset = COMMON_CHARSETS.get(object);
        } else if (matcher3.matches()) {
            object = "windows-" + matcher3.group(1);
            charset = COMMON_CHARSETS.get(object);
        }
        if (charset != null) {
            return charset;
        }
        if (getCharsetICU != null) {
            try {
                object2 = (Charset)getCharsetICU.invoke(null, object);
                if (object2 != null) {
                    return object2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Charset.forName((String)object);
    }

    static {
        CharsetUtils.initCommonCharsets("Big5", "EUC-JP", "EUC-KR", "x-EUC-TW", "GB18030", "IBM855", "IBM866", "ISO-2022-CN", "ISO-2022-JP", "ISO-2022-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-11", "ISO-8859-13", "ISO-8859-15", "KOI8-R", "x-MacCyrillic", "SHIFT_JIS", "UTF-8", "UTF-16BE", "UTF-16LE", "windows-1251", "windows-1252", "windows-1253", "windows-1255");
        COMMON_CHARSETS.put("iso-8851-1", COMMON_CHARSETS.get("iso-8859-1"));
        COMMON_CHARSETS.put("windows", COMMON_CHARSETS.get("windows-1252"));
        COMMON_CHARSETS.put("koi8r", COMMON_CHARSETS.get("koi8-r"));
        Class<?> clazz = null;
        try {
            clazz = CharsetUtils.class.getClassLoader().loadClass("com.ibm.icu.charset.CharsetICU");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                getCharsetICU = clazz.getMethod("forNameICU", String.class);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            try {
                isSupportedICU = clazz.getMethod("isSupported", String.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

