/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;

public class ExceptionUtils {
    private static final Pattern MSG_PATTERN = Pattern.compile(":[^\r\n]+");

    public static String getFilteredStackTrace(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable instanceof TikaException && throwable.getCause() != null) {
            throwable2 = throwable.getCause();
        }
        return ExceptionUtils.getStackTrace(throwable2);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        try {
            printWriter.flush();
            ((Writer)stringWriter).flush();
            printWriter.close();
            ((Writer)stringWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)stringWriter).toString();
    }

    public static String trimMessage(String string) {
        Matcher matcher = MSG_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.replaceFirst("");
        }
        return string;
    }
}

