/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.parboiled.common.Preconditions;

public final class FileUtils {
    private FileUtils() {
    }

    public static String readAllTextFromResource(String resource) {
        Preconditions.checkArgNotNull(resource, "resource");
        return FileUtils.readAllText(FileUtils.class.getClassLoader().getResourceAsStream(resource));
    }

    public static String readAllTextFromResource(String resource, Charset charset) {
        Preconditions.checkArgNotNull(resource, "resource");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllText(FileUtils.class.getClassLoader().getResourceAsStream(resource), charset);
    }

    public static String readAllText(String filename) {
        Preconditions.checkArgNotNull(filename, "filename");
        return FileUtils.readAllText(new File(filename));
    }

    public static String readAllText(String filename, Charset charset) {
        Preconditions.checkArgNotNull(filename, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllText(new File(filename), charset);
    }

    public static String readAllText(File file) {
        Preconditions.checkArgNotNull(file, "file");
        return FileUtils.readAllText(file, Charset.forName("UTF8"));
    }

    public static String readAllText(File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            return FileUtils.readAllText(new FileInputStream(file), charset);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static String readAllText(InputStream stream) {
        return FileUtils.readAllText(stream, Charset.forName("UTF8"));
    }

    public static String readAllText(InputStream stream, Charset charset) {
        Preconditions.checkArgNotNull(charset, "charset");
        if (stream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        StringWriter writer = new StringWriter();
        FileUtils.copyAll(reader, writer);
        return writer.toString();
    }

    public static char[] readAllCharsFromResource(String resource) {
        Preconditions.checkArgNotNull(resource, "resource");
        return FileUtils.readAllChars(FileUtils.class.getClassLoader().getResourceAsStream(resource));
    }

    public static char[] readAllCharsFromResource(String resource, Charset charset) {
        Preconditions.checkArgNotNull(resource, "resource");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllChars(FileUtils.class.getClassLoader().getResourceAsStream(resource), charset);
    }

    public static char[] readAllChars(String filename) {
        Preconditions.checkArgNotNull(filename, "filename");
        return FileUtils.readAllChars(new File(filename));
    }

    public static char[] readAllChars(String filename, Charset charset) {
        Preconditions.checkArgNotNull(filename, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        return FileUtils.readAllChars(new File(filename), charset);
    }

    public static char[] readAllChars(File file) {
        Preconditions.checkArgNotNull(file, "file");
        return FileUtils.readAllChars(file, Charset.forName("UTF8"));
    }

    public static char[] readAllChars(File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            return FileUtils.readAllChars(new FileInputStream(file), charset);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static char[] readAllChars(InputStream stream) {
        return FileUtils.readAllChars(stream, Charset.forName("UTF8"));
    }

    public static char[] readAllChars(InputStream stream, Charset charset) {
        Preconditions.checkArgNotNull(charset, "charset");
        if (stream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        CharArrayWriter writer = new CharArrayWriter();
        FileUtils.copyAll(reader, writer);
        return writer.toCharArray();
    }

    public static byte[] readAllBytesFromResource(String resource) {
        Preconditions.checkArgNotNull(resource, "resource");
        return FileUtils.readAllBytes(FileUtils.class.getClassLoader().getResourceAsStream(resource));
    }

    public static byte[] readAllBytes(String filename) {
        Preconditions.checkArgNotNull(filename, "filename");
        return FileUtils.readAllBytes(new File(filename));
    }

    public static byte[] readAllBytes(File file) {
        Preconditions.checkArgNotNull(file, "file");
        try {
            return FileUtils.readAllBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static byte[] readAllBytes(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileUtils.copyAll(in, out);
        return out.toByteArray();
    }

    public static void writeAllText(String text, String filename) {
        Preconditions.checkArgNotNull(filename, "filename");
        FileUtils.writeAllText(text, new File(filename));
    }

    public static void writeAllText(String text, String filename, Charset charset) {
        Preconditions.checkArgNotNull(filename, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        FileUtils.writeAllText(text, new File(filename), charset);
    }

    public static void writeAllText(String text, File file) {
        Preconditions.checkArgNotNull(file, "file");
        FileUtils.writeAllText(text, file, Charset.forName("UTF8"));
    }

    public static void writeAllText(String text, File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            FileUtils.ensureParentDir(file);
            FileUtils.writeAllText(text, new FileOutputStream(file), charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAllText(String text, OutputStream stream) {
        Preconditions.checkArgNotNull(stream, "stream");
        FileUtils.writeAllText(text, stream, Charset.forName("UTF8"));
    }

    public static void writeAllText(String text, OutputStream stream, Charset charset) {
        Preconditions.checkArgNotNull(stream, "stream");
        Preconditions.checkArgNotNull(charset, "charset");
        StringReader reader = new StringReader(text != null ? text : "");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, charset));
        FileUtils.copyAll(reader, writer);
    }

    public static void writeAllChars(char[] chars, String filename) {
        Preconditions.checkArgNotNull(filename, "filename");
        FileUtils.writeAllChars(chars, new File(filename));
    }

    public static void writeAllChars(char[] chars, String filename, Charset charset) {
        Preconditions.checkArgNotNull(filename, "filename");
        Preconditions.checkArgNotNull(charset, "charset");
        FileUtils.writeAllChars(chars, new File(filename), charset);
    }

    public static void writeAllChars(char[] chars, File file) {
        Preconditions.checkArgNotNull(file, "file");
        FileUtils.writeAllChars(chars, file, Charset.forName("UTF8"));
    }

    public static void writeAllChars(char[] chars, File file, Charset charset) {
        Preconditions.checkArgNotNull(file, "file");
        Preconditions.checkArgNotNull(charset, "charset");
        try {
            FileUtils.ensureParentDir(file);
            FileUtils.writeAllChars(chars, new FileOutputStream(file), charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAllChars(char[] chars, OutputStream stream) {
        Preconditions.checkArgNotNull(stream, "stream");
        FileUtils.writeAllChars(chars, stream, Charset.forName("UTF8"));
    }

    public static void writeAllChars(char[] chars, OutputStream stream, Charset charset) {
        Preconditions.checkArgNotNull(stream, "stream");
        Preconditions.checkArgNotNull(charset, "charset");
        CharArrayReader reader = new CharArrayReader(chars != null ? chars : new char[]{});
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, charset));
        FileUtils.copyAll(reader, writer);
    }

    public static void writeAllBytes(byte[] data, String filename) {
        Preconditions.checkArgNotNull(data, "data");
        Preconditions.checkArgNotNull(filename, "filename");
        FileUtils.writeAllBytes(data, new File(filename));
    }

    public static void writeAllBytes(byte[] data, File file) {
        Preconditions.checkArgNotNull(data, "data");
        Preconditions.checkArgNotNull(file, "file");
        try {
            FileUtils.ensureParentDir(file);
            FileUtils.writeAllBytes(data, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAllBytes(byte[] data, OutputStream stream) {
        Preconditions.checkArgNotNull(data, "data");
        Preconditions.checkArgNotNull(stream, "stream");
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedOutputStream out = new BufferedOutputStream(stream);
        FileUtils.copyAll(in, out);
    }

    public static void copyAll(Reader reader, Writer writer) {
        Preconditions.checkArgNotNull(reader, "reader");
        Preconditions.checkArgNotNull(writer, "writer");
        try {
            int count;
            char[] data = new char[4096];
            while ((count = reader.read(data)) >= 0) {
                writer.write(data, 0, count);
            }
            reader.close();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyAll(InputStream in, OutputStream out) {
        Preconditions.checkArgNotNull(in, "in");
        Preconditions.checkArgNotNull(out, "out");
        try {
            int count;
            byte[] data = new byte[4096];
            while ((count = in.read(data)) >= 0) {
                out.write(data, 0, count);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void ensureParentDir(String filename) {
        FileUtils.ensureParentDir(new File(filename));
    }

    public static void ensureParentDir(File file) {
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            try {
                FileUtils.forceMkdir(parentDir);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not create directory %s", parentDir), e);
            }
        }
    }

    public static void forceMkdir(File directory) throws IOException {
        if (directory.exists()) {
            if (directory.isFile()) {
                throw new IOException("File '" + directory + "' exists and is not a directory. Unable to create directory.");
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Unable to create directory " + directory);
        }
    }
}

