/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.LinkedList;
import org.parboiled.common.ConsoleSink;
import org.parboiled.common.Sink;
import org.parboiled.common.StringUtils;
import org.parboiled.support.DefaultValueStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggingValueStack<V>
extends DefaultValueStack<V> {
    public final Sink<String> log;

    public DebuggingValueStack() {
        this(new ConsoleSink());
    }

    public DebuggingValueStack(Sink<String> log) {
        this.log = log;
    }

    public DebuggingValueStack(Iterable<V> values) {
        this(values, new ConsoleSink());
    }

    public DebuggingValueStack(Iterable<V> values, Sink<String> log) {
        super(values);
        this.log = log;
    }

    @Override
    public void clear() {
        if (this.head != null) {
            super.clear();
            this.log("clear");
        }
    }

    @Override
    public void restoreSnapshot(Object snapshot) {
        if (this.head == null && snapshot == null || this.head != null && this.head.equals(snapshot)) {
            return;
        }
        super.restoreSnapshot(snapshot);
        this.log("restoreSnapshot");
    }

    @Override
    public void push(V value) {
        super.push(value);
        this.log("push");
    }

    @Override
    public void push(int down, V value) {
        super.push(down, value);
        this.log("push");
    }

    @Override
    public V pop(int down) {
        Object v = super.pop(down);
        this.log("pop");
        return v;
    }

    @Override
    public void poke(int down, V value) {
        super.poke(down, value);
        this.log("poke");
    }

    @Override
    public void swap() {
        super.swap();
        this.log("swap");
    }

    @Override
    public void swap3() {
        super.swap3();
        this.log("swap3");
    }

    @Override
    public void swap4() {
        super.swap4();
        this.log("swap4");
    }

    @Override
    public void swap5() {
        super.swap5();
        this.log("swap5");
    }

    @Override
    public void swap6() {
        super.swap6();
        this.log("swap6");
    }

    protected void log(String action) {
        this.log.receive(action);
        this.log.receive(StringUtils.repeat(' ', 15 - action.length()));
        this.log.receive(": ");
        LinkedList elements = new LinkedList();
        for (Object v : this) {
            elements.addFirst(v);
        }
        this.log.receive(StringUtils.join(elements, ", "));
        this.log.receive("\n");
    }
}

