/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;

class RuleMethodRewriter
implements RuleMethodProcessor {
    private RuleMethod method;
    private InstructionGroup group;
    private int actionNr;
    private int varInitNr;

    RuleMethodRewriter() {
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return method.containsExplicitActions() || method.containsVars();
    }

    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        this.method = (RuleMethod)((Object)Preconditions.checkArgNotNull((Object)((Object)method), (String)"method"));
        this.actionNr = 0;
        this.varInitNr = 0;
        Iterator<InstructionGroup> i$ = method.getGroups().iterator();
        while (i$.hasNext()) {
            InstructionGroup group;
            this.group = group = i$.next();
            this.createNewGroupClassInstance();
            this.initializeFields();
            InstructionGraphNode root = group.getRoot();
            if (root.isActionRoot()) {
                this.removeGroupRootInstruction();
                continue;
            }
            ((MethodInsnNode)root.getInstruction()).desc = "(Lorg/parboiled/common/Factory;)V";
        }
        method.setBodyRewritten();
    }

    private void createNewGroupClassInstance() {
        String internalName = this.group.getGroupClassType().getInternalName();
        InstructionGraphNode root = this.group.getRoot();
        this.insert((AbstractInsnNode)new TypeInsnNode(187, internalName));
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new LdcInsnNode((Object)(this.method.name + (root.isActionRoot() ? "_Action" + ++this.actionNr : "_VarInit" + ++this.varInitNr))));
        this.insert((AbstractInsnNode)new MethodInsnNode(183, internalName, "<init>", "(Ljava/lang/String;)V"));
        if (root.isActionRoot() && this.method.hasSkipActionsInPredicatesAnnotation()) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new MethodInsnNode(182, internalName, "setSkipInPredicates", "()V"));
        }
    }

    private void initializeFields() {
        String internalName = this.group.getGroupClassType().getInternalName();
        for (FieldNode field : this.group.getFields()) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new VarInsnNode(AsmUtils.getLoadingOpcode((Type)field.value), field.access));
            this.insert((AbstractInsnNode)new FieldInsnNode(181, internalName, field.name, field.desc));
        }
    }

    private void insert(AbstractInsnNode insn) {
        this.method.instructions.insertBefore(this.group.getRoot().getInstruction(), insn);
    }

    private void removeGroupRootInstruction() {
        this.method.instructions.remove(this.group.getRoot().getInstruction());
    }
}

